/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol;

import com.google.common.base.Strings;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.BpdAuthLevel;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.Operation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="decisionSwitch")
public class DecisionSwitch {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionSwitch.class);

    public boolean isDialogAnonymous(HbciSandboxContext context) {
        return Strings.isNullOrEmpty((String)context.getRequestPin()) || Operation.DIALOG_INIT_ANON == context.getRequestOperation();
    }

    public boolean isDialogPinTanOk(HbciSandboxContext context) {
        return context.isPinOk() && context.isTanOk();
    }

    public boolean isWrongScaMethod(HbciSandboxContext context) {
        if (Strings.isNullOrEmpty((String)context.getReferencedScaMethodId()) || !context.getUser().getScaMethodsAvailable().contains(context.getReferencedScaMethodId())) {
            log.warn("Wrong or missing TAN method ID: {} / allowed: {}", (Object)context.getReferencedScaMethodId(), context.getUser().getScaMethodsAvailable());
            return true;
        }
        return false;
    }

    public boolean isDialogPinOkAndNoTan(HbciSandboxContext context) {
        return context.isPinOk() && context.isTanEmpty();
    }

    public boolean isDialogInit(HbciSandboxContext context) {
        return Operation.DIALOG_INIT == context.getRequestOperation() && !this.isDialogInitScaTan2Step(context);
    }

    public boolean isDialogInitSca(HbciSandboxContext context) {
        return Operation.DIALOG_INIT_SCA == context.getRequestOperation() && !this.isDialogInitScaTan2Step(context);
    }

    public boolean isDialogInitScaTan2Step(HbciSandboxContext context) {
        return Operation.DIALOG_INIT_SCA_TAN_2_STEP == context.getRequestOperation();
    }

    public boolean isCustomMessage(HbciSandboxContext context) {
        return Operation.CUSTOM_MSG == context.getRequestOperation();
    }

    public boolean isSynchronization(HbciSandboxContext context) {
        return Operation.SYNCH == context.getRequestOperation();
    }

    public boolean isDialogEnd(HbciSandboxContext context) {
        return Operation.DIALOG_END == context.getRequestOperation();
    }

    public boolean anonymousBpdSupported(HbciSandboxContext context) {
        return BpdAuthLevel.ANONYMOUS == context.getBank().getSecurity().getBankParametersData();
    }
}

