/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.domain;

import de.adorsys.multibanking.domain.PaymentStatus;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.Transaction;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import lombok.Generated;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class HbciSandboxPayment {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="hbci_sandbox_payment_id_generator")
    @SequenceGenerator(name="hbci_sandbox_payment_id_generator", sequenceName="hbci_sandbox_payment_id_seq")
    private long id;
    @Column(nullable=false)
    private String ownerLogin;
    @Column(nullable=false)
    private String orderReference;
    @Column(nullable=false)
    private String deduceFrom;
    @Column(nullable=false)
    private String sendTo;
    @Column(nullable=false)
    private BigDecimal amount;
    @Column(nullable=false)
    private String currency;
    private String remittanceUnstructured;
    @Enumerated(value=EnumType.STRING)
    private PaymentStatus status;
    @Column(nullable=false)
    private boolean instantPayment;
    @CreatedDate
    private Instant createdAt;
    @LastModifiedDate
    private Instant modifiedAt;

    public int getHbciStatus() {
        switch (this.getStatus()) {
            case CANC: {
                return 1;
            }
            case RJCT: {
                return 2;
            }
            case PDNG: {
                return 3;
            }
            case ACCC: {
                return 4;
            }
            case ACSC: {
                return 7;
            }
        }
        throw new IllegalStateException("Unmappable payment status: " + this.getStatus());
    }

    public String getModifiedAtString() {
        return DateTimeFormatter.ISO_DATE_TIME.format(this.getModifiedAt().atOffset(ZoneOffset.UTC).toLocalDateTime());
    }

    public String getModifiedAtDateString() {
        return DateTimeFormatter.ISO_DATE.format(this.getModifiedAt().atOffset(ZoneOffset.UTC).toLocalDate());
    }

    public Transaction toTransaction(String accountNumber, BigDecimal balance) {
        Transaction transaction = new Transaction();
        if (this.getDeduceFrom().endsWith(accountNumber)) {
            transaction.setAmount(this.getAmount().negate().toString());
            transaction.setBalanceAfter(balance.subtract(this.getAmount()).toString());
        } else {
            transaction.setAmount(this.getAmount().toString());
            transaction.setBalanceAfter(balance.add(this.getAmount()).toString());
        }
        transaction.setBalanceBefore(balance.toString());
        transaction.setCurrency(Currency.getInstance(this.getCurrency()));
        transaction.setDate(this.getModifiedAtString());
        transaction.setPurpose(this.getRemittanceUnstructured());
        transaction.setTo(this.getSendTo());
        transaction.setFrom(this.getDeduceFrom());
        return transaction;
    }

    @Generated
    public HbciSandboxPayment() {
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getOwnerLogin() {
        return this.ownerLogin;
    }

    @Generated
    public String getOrderReference() {
        return this.orderReference;
    }

    @Generated
    public String getDeduceFrom() {
        return this.deduceFrom;
    }

    @Generated
    public String getSendTo() {
        return this.sendTo;
    }

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getRemittanceUnstructured() {
        return this.remittanceUnstructured;
    }

    @Generated
    public PaymentStatus getStatus() {
        return this.status;
    }

    @Generated
    public boolean isInstantPayment() {
        return this.instantPayment;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getModifiedAt() {
        return this.modifiedAt;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setOwnerLogin(String ownerLogin) {
        this.ownerLogin = ownerLogin;
    }

    @Generated
    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    @Generated
    public void setDeduceFrom(String deduceFrom) {
        this.deduceFrom = deduceFrom;
    }

    @Generated
    public void setSendTo(String sendTo) {
        this.sendTo = sendTo;
    }

    @Generated
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setRemittanceUnstructured(String remittanceUnstructured) {
        this.remittanceUnstructured = remittanceUnstructured;
    }

    @Generated
    public void setStatus(PaymentStatus status) {
        this.status = status;
    }

    @Generated
    public void setInstantPayment(boolean instantPayment) {
        this.instantPayment = instantPayment;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setModifiedAt(Instant modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbciSandboxPayment)) {
            return false;
        }
        HbciSandboxPayment other = (HbciSandboxPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$ownerLogin = this.getOwnerLogin();
        String other$ownerLogin = other.getOwnerLogin();
        if (this$ownerLogin == null ? other$ownerLogin != null : !this$ownerLogin.equals(other$ownerLogin)) {
            return false;
        }
        String this$orderReference = this.getOrderReference();
        String other$orderReference = other.getOrderReference();
        if (this$orderReference == null ? other$orderReference != null : !this$orderReference.equals(other$orderReference)) {
            return false;
        }
        String this$deduceFrom = this.getDeduceFrom();
        String other$deduceFrom = other.getDeduceFrom();
        if (this$deduceFrom == null ? other$deduceFrom != null : !this$deduceFrom.equals(other$deduceFrom)) {
            return false;
        }
        String this$sendTo = this.getSendTo();
        String other$sendTo = other.getSendTo();
        if (this$sendTo == null ? other$sendTo != null : !this$sendTo.equals(other$sendTo)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$remittanceUnstructured = this.getRemittanceUnstructured();
        String other$remittanceUnstructured = other.getRemittanceUnstructured();
        if (this$remittanceUnstructured == null ? other$remittanceUnstructured != null : !this$remittanceUnstructured.equals(other$remittanceUnstructured)) {
            return false;
        }
        PaymentStatus this$status = this.getStatus();
        PaymentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        if (this.isInstantPayment() != other.isInstantPayment()) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$modifiedAt = this.getModifiedAt();
        Instant other$modifiedAt = other.getModifiedAt();
        return !(this$modifiedAt == null ? other$modifiedAt != null : !((Object)this$modifiedAt).equals(other$modifiedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HbciSandboxPayment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        String $ownerLogin = this.getOwnerLogin();
        result = result * 59 + ($ownerLogin == null ? 43 : $ownerLogin.hashCode());
        String $orderReference = this.getOrderReference();
        result = result * 59 + ($orderReference == null ? 43 : $orderReference.hashCode());
        String $deduceFrom = this.getDeduceFrom();
        result = result * 59 + ($deduceFrom == null ? 43 : $deduceFrom.hashCode());
        String $sendTo = this.getSendTo();
        result = result * 59 + ($sendTo == null ? 43 : $sendTo.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $remittanceUnstructured = this.getRemittanceUnstructured();
        result = result * 59 + ($remittanceUnstructured == null ? 43 : $remittanceUnstructured.hashCode());
        PaymentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        result = result * 59 + (this.isInstantPayment() ? 79 : 97);
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $modifiedAt = this.getModifiedAt();
        result = result * 59 + ($modifiedAt == null ? 43 : ((Object)$modifiedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HbciSandboxPayment(id=" + this.getId() + ", ownerLogin=" + this.getOwnerLogin() + ", orderReference=" + this.getOrderReference() + ", deduceFrom=" + this.getDeduceFrom() + ", sendTo=" + this.getSendTo() + ", amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", remittanceUnstructured=" + this.getRemittanceUnstructured() + ", status=" + this.getStatus() + ", instantPayment=" + this.isInstantPayment() + ", createdAt=" + this.getCreatedAt() + ", modifiedAt=" + this.getModifiedAt() + ")";
    }
}

