/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol.common;

import de.adorsys.opba.protocol.sandbox.hbci.config.HbciConfig;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="extractBankAndUser")
public class ExtractBankAndUserIfAvailable
implements JavaDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtractBankAndUserIfAvailable.class);
    private final HbciConfig config;

    public void execute(DelegateExecution execution) {
        HbciSandboxContext context = (HbciSandboxContext)execution.getVariable("CONTEXT");
        this.updateBankIfNeeded(context, context.getRequestBankBlz());
        this.updateUserIfNeeded(context, context.getRequestUserLogin());
        execution.setVariable("CONTEXT", (Object)context);
    }

    private void updateBankIfNeeded(HbciSandboxContext context, String bankBlz) {
        if (Strings.isBlank((String)bankBlz)) {
            return;
        }
        if (null != context.getBank()) {
            if (context.getBank().getBlz().equals(bankBlz)) {
                return;
            }
            throw new IllegalStateException(String.format("Bank BLZ redefinition: current: %s target %s", context.getBank().getBlz(), bankBlz));
        }
        log.info("Setting bank with BLZ {} for dialogId {}", (Object)bankBlz, (Object)context.getDialogId());
        context.setBank(this.config.getBanks().stream().filter(it -> it.getBlz().equals(bankBlz)).findFirst().orElseThrow(() -> new IllegalStateException("Unknown bank BLZ: " + bankBlz)));
    }

    private void updateUserIfNeeded(HbciSandboxContext context, String userLogin) {
        if (Strings.isBlank((String)userLogin)) {
            return;
        }
        if (null != context.getUser()) {
            if (context.getUser().getLogin().equals(userLogin)) {
                return;
            }
            throw new IllegalStateException(String.format("User redefinition: current: %s target %s", context.getUser().getLogin(), userLogin));
        }
        log.info("Setting user with login {} for dialogId {}", (Object)userLogin, (Object)context.getDialogId());
        context.setUser(this.config.getUsers().stream().filter(it -> it.getLogin().equals(userLogin)).findFirst().orElseGet(() -> {
            log.info("Login {} is anonymous for dialogId {}", (Object)userLogin, (Object)context.getDialogId());
            return null;
        }));
    }

    @ConstructorProperties(value={"config"})
    @Generated
    public ExtractBankAndUserIfAvailable(HbciConfig config) {
        this.config = config;
    }
}

