/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.controller;

import com.google.common.base.Joiner;
import de.adorsys.opba.protocol.sandbox.hbci.service.HbciMockService;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/hbci-mock/*"})
public class HbciRestController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HbciRestController.class);
    private final HbciMockService hbciMockService;

    @PostMapping(produces={"text/plain"}, consumes={"application/octet-stream"})
    public String hbciPostRequest(@RequestBody String requestEncoded) {
        return this.doHandle(requestEncoded);
    }

    @PostMapping(produces={"text/plain"}, consumes={"text/plain"})
    public String hbciPostRequestPlain(@RequestBody String requestEncoded) {
        return this.doHandle(requestEncoded);
    }

    private String doHandle(@RequestBody String requestEncoded) {
        log.info("request: \nRQ-->:\n{}\n", (Object)this.decode(requestEncoded));
        String result = this.hbciMockService.handleRequest(requestEncoded);
        log.info("response: \nRS-->:\n{}\n", (Object)result);
        return this.encode(result);
    }

    private String decode(String encoded) {
        return Joiner.on((String)"\n").join((Object[])new String(Base64.decodeBase64((String)encoded)).split("'"));
    }

    private String encode(String rawWithoutReturns) {
        return Base64.encodeBase64String((byte[])rawWithoutReturns.getBytes(StandardCharsets.ISO_8859_1));
    }

    @ConstructorProperties(value={"hbciMockService"})
    @Generated
    public HbciRestController(HbciMockService hbciMockService) {
        this.hbciMockService = hbciMockService;
    }
}

