/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import de.adorsys.oauth.server.AuthenticatorMatcher;
import de.adorsys.oauth.server.BasicAuthenticatorMatcher;
import de.adorsys.oauth.server.BearerTokenMatcher;
import de.adorsys.oauth.server.FixedServletUtils;
import de.adorsys.oauth.server.FormAuthenticationMatcher;
import de.adorsys.oauth.server.RememberMeMatcher;
import de.adorsys.oauth.server.TokenEndpointMatcher;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.util.AttachmentKey;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateAuthenticationMechanism
implements AuthenticationMechanism,
PolicyContextHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateAuthenticationMechanism.class);
    private static final String[] SUPPORTED_CONTEXT = new String[]{HttpServletRequest.class.getName(), HttpServletResponse.class.getName(), AuthorizationRequest.class.getName(), TokenRequest.class.getName()};
    private static ThreadLocal<Map<String, Object>> contextData = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static final AttachmentKey<AuthenticationMechanism> AUTHENTICATION_MECHANISM_ATTACHMENT_KEY = AttachmentKey.create(AuthenticationMechanism.class);
    private List<AuthenticatorMatcher> authenticatioMatchers = new ArrayList<AuthenticatorMatcher>();

    public DelegateAuthenticationMechanism(ServletContext servletContext) {
        this.authenticatioMatchers.add(new TokenEndpointMatcher());
        this.authenticatioMatchers.add(new RememberMeMatcher());
        this.authenticatioMatchers.add(new FormAuthenticationMatcher());
        this.authenticatioMatchers.add(new BasicAuthenticatorMatcher());
        this.authenticatioMatchers.add(new BearerTokenMatcher());
        for (AuthenticatorMatcher authenticatioMatcher : this.authenticatioMatchers) {
            authenticatioMatcher.initialize(servletContext);
        }
        for (String key : SUPPORTED_CONTEXT) {
            try {
                PolicyContext.registerHandler((String)key, (PolicyContextHandler)this, (boolean)false);
            }
            catch (Exception e) {
                LOG.debug(e.getClass().getSimpleName() + " " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
        HTTPRequest httpRequest = FixedServletUtils.createHTTPRequest((HttpServletRequest)request);
        AuthorizationRequest authorizationRequest = this.resolveAuthorizationRequest(httpRequest);
        TokenRequest tokenRequest = this.resolveTokenRequest(httpRequest);
        this.store(HttpServletRequest.class.getName(), request).store(HttpServletResponse.class.getName(), servletRequestContext.getOriginalResponse()).store(AuthorizationRequest.class.getName(), authorizationRequest).store(TokenRequest.class.getName(), tokenRequest);
        try {
            for (AuthenticatorMatcher authenicatorMatcher : this.authenticatioMatchers) {
                if (!authenicatorMatcher.match(exchange, (HttpServletRequest)request)) continue;
                LOG.debug("use {}", (Object)authenicatorMatcher.getClass().getSimpleName());
                exchange.putAttachment(AUTHENTICATION_MECHANISM_ATTACHMENT_KEY, (Object)authenicatorMatcher);
                AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = authenicatorMatcher.authenticate(exchange, securityContext);
                return authenticationMechanismOutcome;
            }
        }
        finally {
            for (String key : SUPPORTED_CONTEXT) {
                contextData.get().remove(key);
            }
        }
        LOG.debug("no authenicatorMatcher found for {}", (Object)exchange);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        AuthenticationMechanism authenticationMechanism = (AuthenticationMechanism)exchange.getAttachment(AUTHENTICATION_MECHANISM_ATTACHMENT_KEY);
        return authenticationMechanism == null ? new AuthenticationMechanism.ChallengeResult(false, Integer.valueOf(401)) : authenticationMechanism.sendChallenge(exchange, securityContext);
    }

    private void debugRequest(HttpServletRequest request) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String method = request.getMethod();
        StringBuilder sb = new StringBuilder(method).append(' ');
        sb.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getRequestURI());
        if (method.equals("GET")) {
            sb.append(request.getQueryString());
        } else {
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String param = (String)parameterNames.nextElement();
                sb.append("\n ").append(param).append("=");
                String value = request.getParameter(param);
                try {
                    sb.append(URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    sb.append(value);
                }
            }
        }
        LOG.debug(sb.toString());
    }

    private DelegateAuthenticationMechanism store(String key, Object value) {
        if (value != null) {
            contextData.get().put(key, value);
        }
        return this;
    }

    private AuthorizationRequest resolveAuthorizationRequest(HTTPRequest httpRequest) {
        try {
            return AuthorizationRequest.parse((HTTPRequest)httpRequest);
        }
        catch (Exception exception) {
            try {
                return AuthorizationRequest.parse((String)httpRequest.getQuery());
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private TokenRequest resolveTokenRequest(HTTPRequest httpRequest) {
        try {
            return TokenRequest.parse((HTTPRequest)httpRequest);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        return contextData.get().get(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{HttpServletRequest.class.getName(), HttpServletResponse.class.getName()};
    }

    public boolean supports(String key) throws PolicyContextException {
        for (String supported : SUPPORTED_CONTEXT) {
            if (!supported.equals(key)) continue;
            return true;
        }
        return false;
    }
}

