/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import de.adorsys.oauth.server.AuthenticatorMatcher;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.impl.BasicAuthenticationMechanism;
import io.undertow.server.HttpServerExchange;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticatorMatcher
implements AuthenticatorMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticatorMatcher.class);
    private AuthenticationMechanism baseAuthenticationMechanism;

    @Override
    public void initialize(ServletContext servletContext) {
        this.baseAuthenticationMechanism = new BasicAuthenticationMechanism(servletContext.getServletContextName(), "BASIC");
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        return this.baseAuthenticationMechanism.authenticate(exchange, securityContext);
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return this.baseAuthenticationMechanism.sendChallenge(exchange, securityContext);
    }

    @Override
    public boolean match(HttpServerExchange exchange, HttpServletRequest request) {
        for (String name : Collections.list(request.getHeaderNames())) {
            if (!"authorization".equalsIgnoreCase(name)) continue;
            return request.getHeader(name).substring(0, 5).equalsIgnoreCase("Basic");
        }
        return false;
    }
}

