/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import de.adorsys.oauth.server.AuthenticatorMatcher;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class RememberMeMatcher
implements AuthenticatorMatcher {
    @Override
    public void initialize(ServletContext servletContext) {
    }

    @Override
    public boolean match(HttpServerExchange exchange, HttpServletRequest request) {
        String clientId = request.getParameter("client_id");
        if (!request.getRequestURI().endsWith("/auth") || clientId == null) {
            return false;
        }
        Cookie cookieToken = this.getCookieToken(clientId, request);
        return cookieToken != null;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Account account = securityContext.getIdentityManager().verify("guest", (Credential)new PasswordCredential("test".toCharArray()));
        if (account == null) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        securityContext.authenticationComplete(account, "OAUTH", false);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    private Cookie getCookieToken(String clientId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("REMEMBER_" + clientId) || !StringUtils.isNotEmpty((CharSequence)cookie.getValue())) continue;
            return cookie;
        }
        return null;
    }
}

