/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import de.adorsys.oauth.server.AuthenticatorMatcher;
import de.adorsys.oauth.server.OAuhtAccount;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenEndpointMatcher
implements AuthenticatorMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(TokenEndpointMatcher.class);

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
        HttpServletResponseImpl response = servletRequestContext.getOriginalResponse();
        TokenRequest tokenRequest = this.resolveTokenRequest();
        if (tokenRequest == null) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (authorizationGrant.getType() == GrantType.AUTHORIZATION_CODE || authorizationGrant.getType() == GrantType.REFRESH_TOKEN) {
            securityContext.authenticationComplete((Account)OAuhtAccount.INSTANCE, "OAUTH", false);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        if (authorizationGrant.getType() != GrantType.PASSWORD) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        }
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authorizationGrant;
        String userName = grant.getUsername();
        String password = grant.getPassword().getValue() == null ? "" : grant.getPassword().getValue();
        LOG.debug("PasswordFlow - login {} {}", (Object)userName, (Object)password.replaceAll(".", "x"));
        IdentityManager identityManager = securityContext.getIdentityManager();
        Account account = identityManager.verify(userName, (Credential)new PasswordCredential(password.toCharArray()));
        if (account == null) {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        securityContext.authenticationComplete(account, "OAUTH", false);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(403));
    }

    private TokenRequest resolveTokenRequest() {
        try {
            return (TokenRequest)PolicyContext.getContext((String)TokenRequest.class.getName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void initialize(ServletContext servletContext) {
    }

    @Override
    public boolean match(HttpServerExchange exchange, HttpServletRequest request) {
        TokenRequest tokenRequest = this.resolveTokenRequest();
        return tokenRequest != null;
    }
}

