/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import de.adorsys.oauth.server.AuthenticatorMatcher;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.PasswordCredential;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.Methods;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class FormAuthenticationMatcher
implements AuthenticatorMatcher {
    private static final String FORM_PASSWORD = "j_password";
    private static final String FORM_USERNAME = "j_username";
    private static final String DEFAULT_LOGIN_ERROR_PAGE = "/loginError.jsp";
    private static final String DEFAULT_LOGIN_PAGE = "/login.jsp";
    private static final String DEFAULT_POST_LOCATION = "/api/auth";
    private String loginPage;
    private String loginErrorPage;

    @Override
    public void initialize(ServletContext servletContext) {
        ServletContextImpl contextImpl = (ServletContextImpl)servletContext;
        this.loginPage = this.resolveLoginPage(contextImpl);
        this.loginErrorPage = this.resolveLoginErrorPage(contextImpl);
    }

    private String resolveLoginErrorPage(ServletContextImpl contextImpl) {
        String result;
        LoginConfig loginConfig = contextImpl.getDeployment().getDeploymentInfo().getLoginConfig();
        String string = result = loginConfig == null ? null : loginConfig.getErrorPage();
        if (result == null) {
            result = DEFAULT_LOGIN_ERROR_PAGE;
        }
        return result;
    }

    private String resolveLoginPage(ServletContextImpl contextImpl) {
        String result;
        LoginConfig loginConfig = contextImpl.getDeployment().getDeploymentInfo().getLoginConfig();
        String string = result = loginConfig == null ? null : loginConfig.getLoginPage();
        if (result == null) {
            result = DEFAULT_LOGIN_PAGE;
        }
        return result;
    }

    @Override
    public boolean match(HttpServerExchange exchange, HttpServletRequest request) {
        String query = request.getQueryString();
        return query != null && query.contains("response_type") || request.getParameter("response_type") != null;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
        if ("POST".equals(request.getMethod())) {
            String username = request.getParameter(FORM_USERNAME);
            String password = request.getParameter(FORM_PASSWORD);
            Account account = securityContext.getIdentityManager().verify(username, (Credential)new PasswordCredential(password.toCharArray()));
            if (account == null) {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            securityContext.authenticationComplete(account, "OAUTH", false);
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        String forwardTo = this.loginPage;
        if (exchange.getRequestURI().endsWith(DEFAULT_POST_LOCATION) && exchange.getRequestMethod().equals(Methods.POST)) {
            forwardTo = this.loginErrorPage;
        }
        this.forward(exchange, forwardTo);
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    private void forward(HttpServerExchange exchange, String page) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(page);
        try {
            requestDispatcher.forward((ServletRequest)request, servletRequestContext.getServletResponse());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

