/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.mongodb;

import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.LoginSessionToken;
import java.util.Date;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.bson.Document;

public class TokenDocument<T extends Token> {
    private final T token;
    private final TokenType type;
    private final Date created;
    private final Map<String, Object> userInfo;
    private final Date expires;
    private final ClientID clientId;
    private final LoginSessionToken sessionId;
    private String refreshTokenRef;

    public TokenDocument(T token, Date created, ClientID clientId, LoginSessionToken sessionId, UserInfo userInfo) {
        this(token, created, clientId, sessionId, userInfo, 0);
    }

    public TokenDocument(T token, Date created, ClientID clientId, LoginSessionToken sessionId, UserInfo userInfo, int refreshTokenLifeTime) {
        if (token instanceof BearerAccessToken) {
            this.type = TokenType.ACCESS;
        } else if (token instanceof RefreshToken) {
            this.type = TokenType.REFRESH;
        } else {
            throw new IllegalArgumentException("Unknow token type " + token.getClass().getName());
        }
        this.token = token;
        this.created = created;
        this.sessionId = sessionId;
        this.clientId = clientId;
        this.expires = token instanceof AccessToken && 0L != ((AccessToken)token).getLifetime() ? new Date(created.getTime() + ((AccessToken)token).getLifetime() * 1000L) : (refreshTokenLifeTime == 0 ? new Date(Long.MAX_VALUE) : new Date(created.getTime() + (long)(refreshTokenLifeTime * 1000)));
        this.userInfo = userInfo != null ? userInfo.toJSONObject() : null;
    }

    public Document asDocument() {
        Document document = new Document("_id", (Object)this.token.getValue()).append("created", (Object)this.created).append("clientId", (Object)this.clientId.getValue()).append("userInfo", this.userInfo).append("type", (Object)this.type.name());
        if (this.sessionId != null) {
            document.append("sessionId", (Object)this.sessionId.getValue());
        }
        if (this.expires != null) {
            document.append("expires", (Object)this.expires);
        }
        if (this.refreshTokenRef != null) {
            document.append("refreshTokenRef", (Object)this.refreshTokenRef);
        }
        return document;
    }

    public static <T extends Token> TokenDocument<T> from(Document document) {
        TokenDocument<BearerAccessToken> tokenDocument;
        String type = document.getString((Object)"type");
        assert (type != null) : "type is null";
        UserInfo userInfoObject = new UserInfo(new JSONObject((Map)document.get((Object)"userInfo")));
        ClientID clientIdObj = new ClientID(document.getString((Object)"clientId"));
        LoginSessionToken loginSession = document.getString((Object)"sessionId") != null ? new LoginSessionToken(document.getString((Object)"sessionId")) : null;
        Date created = document.getDate((Object)"created");
        if (TokenType.ACCESS.name().equals(type)) {
            long tokenLifetime = (document.getDate((Object)"expires").getTime() - created.getTime()) / 1000L;
            BearerAccessToken bearerAccessToken = new BearerAccessToken(document.getString((Object)"_id"), tokenLifetime, null);
            tokenDocument = new TokenDocument<BearerAccessToken>(bearerAccessToken, created, clientIdObj, loginSession, userInfoObject);
        } else if (TokenType.REFRESH.name().equals(type)) {
            int tokenLifetime = 0;
            if (document.getDate((Object)"expires") != null) {
                tokenLifetime = (int)(document.getDate((Object)"expires").getTime() - created.getTime()) / 1000;
            }
            RefreshToken refreshToken = new RefreshToken(document.getString((Object)"_id"));
            tokenDocument = new TokenDocument<RefreshToken>(refreshToken, created, clientIdObj, loginSession, userInfoObject, tokenLifetime);
        } else {
            throw new IllegalArgumentException("unknow token type " + type);
        }
        tokenDocument.refreshTokenRef = document.getString((Object)"refreshTokenRef");
        return tokenDocument;
    }

    public T asToken() {
        return this.getToken();
    }

    public boolean isValid() {
        return this.expires == null || System.currentTimeMillis() < this.expires.getTime();
    }

    public String toString() {
        return this.asDocument().toJson();
    }

    public UserInfo getUserInfo() {
        return this.userInfo == null ? null : new UserInfo(new JSONObject(this.userInfo));
    }

    public void setRefreshTokenRef(String refreshTokenRef) {
        this.refreshTokenRef = refreshTokenRef;
    }

    public String getRefreshTokenRef() {
        return this.refreshTokenRef;
    }

    public T getToken() {
        return this.token;
    }

    public TokenType getType() {
        return this.type;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public ClientID getClientId() {
        return this.clientId;
    }

    public LoginSessionToken getSessionId() {
        return this.sessionId;
    }

    static enum TokenType {
        ACCESS,
        REFRESH;

    }
}

