/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.mongodb;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.AuthCodeAndMetadata;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.RefreshTokenAndMetadata;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.tokenstore.mongodb.TokenDocument;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minidev.json.JSONObject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MdbTokenStore
implements TokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(MdbTokenStore.class);
    static final String COLLECTION_NAME = System.getProperty("oauth.mongodb.collection", "tokenstore");
    @Inject
    private MongoDatabase mongoDb;
    private MongoCollection<Document> collection;
    private MongoCollection<Document> authCodeCollection;
    private MongoCollection<Document> loginSessionCollection;

    @PostConstruct
    void initCollection() {
        this.collection = this.mongoDb.getCollection(COLLECTION_NAME);
        this.authCodeCollection = this.mongoDb.getCollection("authCode");
        this.loginSessionCollection = this.mongoDb.getCollection("loginSession");
    }

    public void addAuthCode(AuthorizationCode code, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId, URI redirectUri) {
        Document document = new Document("_id", (Object)code.getValue()).append("created", (Object)new Date()).append("expires", (Object)new Date(System.currentTimeMillis() + 60000L)).append("userInfo", (Object)userInfo.toJSONObject()).append("clientId", (Object)clientId.getValue()).append("loginSession", (Object)sessionId.getValue()).append("redirectUri", (Object)redirectUri.toString());
        this.authCodeCollection.insertOne((Object)document);
    }

    public void addRefreshToken(RefreshToken token, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId) {
        TokenDocument<RefreshToken> tokenDocument = new TokenDocument<RefreshToken>(token, new Date(), clientId, sessionId, userInfo);
        Document document = tokenDocument.asDocument();
        this.collection.insertOne((Object)document);
    }

    public void addAccessToken(BearerAccessToken token, UserInfo userInfo, ClientID clientId, RefreshToken refreshToken) {
        TokenDocument<BearerAccessToken> tokenDocument = new TokenDocument<BearerAccessToken>(token, new Date(), clientId, null, userInfo);
        if (refreshToken != null) {
            tokenDocument.setRefreshTokenRef(refreshToken.getValue());
        }
        Document document = tokenDocument.asDocument();
        this.collection.insertOne((Object)document);
    }

    public void remove(String id, ClientID clientId) {
        Document query = new Document("_id", (Object)id);
        Document refreshQuery = new Document("refreshTokenRef", (Object)id);
        if (clientId != null) {
            query.append("clientId", (Object)clientId.getValue());
            refreshQuery.append("clientId", (Object)clientId.getValue());
        }
        DeleteResult result = this.collection.deleteOne((Bson)query);
        LOG.debug("delete {} : {} tokens", (Object)id, (Object)result.getDeletedCount());
        result = this.collection.deleteMany((Bson)refreshQuery);
        LOG.debug("delete {} : {} access tokens", (Object)id, (Object)result.getDeletedCount());
    }

    public AccessToken load(String id) {
        Document document = (Document)this.collection.find((Bson)new Document().append("_id", (Object)id)).first();
        return document == null ? null : (AccessToken)TokenDocument.from(document).getToken();
    }

    public boolean isValid(String id) {
        Document document = (Document)this.collection.find((Bson)new Document().append("_id", (Object)id)).first();
        return document != null && TokenDocument.from(document).isValid();
    }

    public void addLoginSession(LoginSessionToken sessionId, UserInfo userInfo) {
        Document document = new Document("_id", (Object)sessionId.getValue()).append("created", (Object)new Date()).append("userInfo", (Object)userInfo.toJSONObject()).append("valid", (Object)Boolean.TRUE);
        this.loginSessionCollection.insertOne((Object)document);
    }

    public UserInfo loadUserInfoFromLoginSession(LoginSessionToken sessionId) {
        Document document = (Document)this.loginSessionCollection.find((Bson)new Document().append("_id", (Object)sessionId.getValue())).first();
        if (document == null) {
            return null;
        }
        return new UserInfo(new JSONObject((Map)document.get((Object)"userInfo")));
    }

    public void removeLoginSession(LoginSessionToken sessionId) {
        DeleteResult result = this.loginSessionCollection.deleteOne((Bson)new Document().append("_id", (Object)sessionId.getValue()));
        LOG.debug("delete {} : {} session", (Object)sessionId.getValue(), (Object)result.getDeletedCount());
    }

    public void remove(LoginSessionToken loginSessionToken) {
        FindIterable refreshTokens = this.collection.find((Bson)new Document("sessionId", (Object)loginSessionToken.getValue()));
        for (Document refreshToken : refreshTokens) {
            String refreshTokenId = refreshToken.getString((Object)"_id");
            DeleteResult result = this.collection.deleteMany((Bson)new Document("refreshTokenRef", (Object)refreshTokenId));
            LOG.debug("delete login session {} : {} access tokens", (Object)loginSessionToken.getValue(), (Object)result.getDeletedCount());
        }
        DeleteResult result2 = this.collection.deleteMany((Bson)new Document("sessionId", (Object)loginSessionToken.getValue()));
        LOG.debug("delete login session {} : {} refresh tokens", (Object)loginSessionToken.getValue(), (Object)result2.getDeletedCount());
    }

    public boolean isValid(LoginSessionToken loginSessionToken) {
        Document document = (Document)this.loginSessionCollection.find((Bson)new Document().append("_id", (Object)loginSessionToken.getValue())).first();
        if (document == null) {
            return false;
        }
        return document.getBoolean((Object)"valid") != null ? document.getBoolean((Object)"valid") : false;
    }

    public void invalidateLoginSession(LoginSessionToken loginSessionToken) {
        this.loginSessionCollection.updateOne((Bson)new Document().append("_id", (Object)loginSessionToken.getValue()), (Bson)new Document("$set", (Object)new Document("valid", (Object)Boolean.FALSE)));
    }

    public UserInfo loadUserInfo(String id) {
        Document document = (Document)this.collection.find((Bson)new Document().append("_id", (Object)id)).first();
        return document == null ? null : TokenDocument.from(document).getUserInfo();
    }

    void setMongoDb(MongoDatabase mongoDb) {
        this.mongoDb = mongoDb;
    }

    public AuthCodeAndMetadata consumeAuthCode(AuthorizationCode authCode) {
        Document document = (Document)this.authCodeCollection.findOneAndDelete((Bson)new Document("_id", (Object)authCode.getValue()));
        if (document == null) {
            return null;
        }
        String loginSession = document.getString((Object)"loginSession");
        return new AuthCodeAndMetadata(document.getString((Object)"redirectUri"), new UserInfo(new JSONObject((Map)document.get((Object)"userInfo"))), new ClientID(document.getString((Object)"clientId")), loginSession != null ? new LoginSessionToken(loginSession) : null);
    }

    public RefreshTokenAndMetadata findRefreshToken(RefreshToken refreshToken) {
        Document document = (Document)this.collection.find((Bson)new Document("_id", (Object)refreshToken.getValue())).first();
        if (document != null) {
            TokenDocument tokenDoc = TokenDocument.from(document);
            return new RefreshTokenAndMetadata((RefreshToken)tokenDoc.getToken(), tokenDoc.getUserInfo(), tokenDoc.getClientId(), tokenDoc.getSessionId());
        }
        return null;
    }
}

