/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.mongodb;

import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.tokenstore.mongodb.TokenDocument;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class MdbTokenStore
implements TokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(MdbTokenStore.class);
    static final String COLLECTION_NAME = System.getProperty("oauth.mongodb.collection", "tokenstore");
    @Inject
    private MongoDatabase mongoDb;

    public String add(Token token, UserInfo userInfo, AuthorizationCode authCode) {
        Document document = new TokenDocument(token, userInfo, authCode).asDocument();
        this.mongoDb.getCollection(COLLECTION_NAME).insertOne((Object)document);
        return token.getValue();
    }

    public String add(Token token, UserInfo userInfo) {
        Document document = new TokenDocument(token, userInfo).asDocument();
        this.mongoDb.getCollection(COLLECTION_NAME).insertOne((Object)document);
        return token.getValue();
    }

    public void remove(String id) {
        DeleteResult result = this.mongoDb.getCollection(COLLECTION_NAME).deleteOne((Bson)new Document().append("_id", (Object)id));
        LOG.debug("delete {} : {} documents", (Object)id, (Object)result.getDeletedCount());
    }

    public AccessToken load(String id) {
        Document document = (Document)this.mongoDb.getCollection(COLLECTION_NAME).find((Bson)new Document().append("_id", (Object)id)).first();
        return document == null ? null : TokenDocument.from(document).asAccessToken();
    }

    public AccessToken load(AuthorizationCode authCode) {
        Document document = (Document)this.mongoDb.getCollection(COLLECTION_NAME).find((Bson)new Document().append("authCode", (Object)authCode.getValue())).first();
        return document == null ? null : TokenDocument.from(document).asAccessToken();
    }

    public RefreshToken loadRefreshToken(String id) {
        Document document = (Document)this.mongoDb.getCollection(COLLECTION_NAME).find((Bson)new Document().append("_id", (Object)id)).first();
        return document == null ? null : TokenDocument.from(document).asRefreshToken();
    }

    public boolean isValid(String id) {
        Document document = (Document)this.mongoDb.getCollection(COLLECTION_NAME).find((Bson)new Document().append("_id", (Object)id)).first();
        return document != null && TokenDocument.from(document).isValid();
    }

    public UserInfo loadUserInfo(String id) {
        Document document = (Document)this.mongoDb.getCollection(COLLECTION_NAME).find((Bson)new Document().append("_id", (Object)id)).first();
        return document == null ? null : TokenDocument.from(document).getUserInfo();
    }

    void setMongoDb(MongoDatabase mongoDb) {
        this.mongoDb = mongoDb;
    }
}

