/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.AuthCodeAndMetadata;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.RefreshTokenAndMetadata;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.tokenstore.jpa.AuthCodeEntity;
import de.adorsys.oauth.tokenstore.jpa.LoginSessionEntity;
import de.adorsys.oauth.tokenstore.jpa.TokenEntity;
import java.net.URI;
import javax.ejb.Stateless;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class JpaTokenStore
implements TokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(JpaTokenStore.class);
    @PersistenceContext(unitName="oauth")
    private EntityManager entityManager;

    public RefreshTokenAndMetadata findRefreshToken(RefreshToken refreshToken) {
        if (refreshToken == null || refreshToken.getValue() == null) {
            return null;
        }
        TokenEntity refreshTokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)refreshToken.getValue());
        if (refreshTokenEntity != null) {
            return new RefreshTokenAndMetadata(refreshTokenEntity.asRefreshToken(), refreshTokenEntity.getUserInfo(), refreshTokenEntity.getClientId(), refreshTokenEntity.getLoginSessionToken());
        }
        return null;
    }

    public void addAuthCode(AuthorizationCode code, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId, URI redirectUri) {
        AuthCodeEntity authCodeEntity = new AuthCodeEntity(code, userInfo, clientId, sessionId, redirectUri);
        this.entityManager.persist((Object)authCodeEntity);
        this.entityManager.flush();
    }

    public void addRefreshToken(RefreshToken token, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId) {
        TokenEntity tokenEntity = new TokenEntity((Token)token, userInfo, clientId, sessionId);
        this.entityManager.persist((Object)tokenEntity);
    }

    public void addRefreshToken(RefreshToken token, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId, int refreshTokenLifeTime) {
        TokenEntity tokenEntity = new TokenEntity((Token)token, userInfo, clientId, sessionId, refreshTokenLifeTime);
        this.entityManager.persist((Object)tokenEntity);
    }

    public void addAccessToken(BearerAccessToken token, UserInfo userInfo, ClientID clientId, RefreshToken refreshToken) {
        TokenEntity tokenEntity = new TokenEntity((Token)token, userInfo, clientId, null);
        if (refreshToken != null) {
            TokenEntity refreshTokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)refreshToken.getValue());
            assert (refreshTokenEntity != null) : "existing refresh token is expected if given as argument";
            tokenEntity.setRefreshToken(refreshTokenEntity);
            tokenEntity.setLoginSession(refreshTokenEntity.getLoginSession());
        }
        this.entityManager.persist((Object)tokenEntity);
    }

    public void remove(String id, ClientID clientId) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        if (tokenEntity == null) {
            LOG.warn("Attempt to delete not existing token: " + id);
            return;
        }
        this.entityManager.detach((Object)tokenEntity);
        if (clientId != null && !clientId.equals((Object)tokenEntity.getClientId())) {
            LOG.warn("clientIds are different: " + clientId + " vs. " + tokenEntity.getClientId());
        }
        Query queryRefreshToken = this.entityManager.createNamedQuery("DELETE_REFRESH_TOKEN_BY_PARENT_ID");
        queryRefreshToken.setParameter("id", (Object)id);
        int updateCountRefreshToken = queryRefreshToken.executeUpdate();
        LOG.debug("Removed Refresh-Tokens for parent id {}, count {}", (Object)id, (Object)updateCountRefreshToken);
        Query q = this.entityManager.createNamedQuery("DELETE_TOKEN_BY_ID");
        q.setParameter("id", (Object)id);
        int updateCount = q.executeUpdate();
        LOG.debug("Remove Token {}, Count {}", (Object)id, (Object)updateCount);
    }

    public AccessToken load(String id) {
        Cache cache;
        if (LOG.isDebugEnabled() && (cache = this.entityManager.getEntityManagerFactory().getCache()).contains(TokenEntity.class, (Object)id)) {
            LOG.debug("read token from cache {}", (Object)id);
        }
        TokenEntity entity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return entity.asAccessToken();
    }

    public AuthCodeAndMetadata consumeAuthCode(AuthorizationCode authCode) {
        String authCodeId = authCode.getValue();
        AuthCodeEntity authCodeEntity = (AuthCodeEntity)this.entityManager.find(AuthCodeEntity.class, (Object)authCodeId);
        if (authCodeEntity == null) {
            return null;
        }
        AuthCodeAndMetadata authCodeAndMetadata = new AuthCodeAndMetadata(authCodeEntity.getRedirectUri(), authCodeEntity.getUserInfo(), new ClientID(authCodeEntity.getClientId()), authCodeEntity.getLoginSession() != null ? new LoginSessionToken(authCodeEntity.getLoginSession()) : null);
        this.entityManager.remove((Object)authCodeEntity);
        return authCodeAndMetadata;
    }

    public boolean isValid(String id) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return tokenEntity != null && tokenEntity.isValid();
    }

    public void addLoginSession(LoginSessionToken sessionId, UserInfo userInfo) {
        LoginSessionEntity loginSessionEntity = new LoginSessionEntity(sessionId, userInfo);
        this.entityManager.persist((Object)loginSessionEntity);
    }

    public UserInfo loadUserInfoFromLoginSession(LoginSessionToken sessionId) {
        if (sessionId == null) {
            return null;
        }
        LoginSessionEntity loginSessionEntity = (LoginSessionEntity)this.entityManager.find(LoginSessionEntity.class, (Object)sessionId.getValue());
        if (loginSessionEntity != null) {
            return loginSessionEntity.getUserInfo();
        }
        return null;
    }

    public void removeLoginSession(LoginSessionToken sessionId) {
        this.entityManager.createNamedQuery("DELETE_LOGIN_SESSION").setParameter("id", (Object)sessionId.getValue()).executeUpdate();
    }

    public void remove(LoginSessionToken loginSessionToken) {
        Query queryDeleteATokens = this.entityManager.createNamedQuery("DELETE_ACCESS_TOKEN_BY_LOGINSESSION");
        queryDeleteATokens.setParameter("loginSession", (Object)loginSessionToken.getValue());
        int deletedAccessTokens = queryDeleteATokens.executeUpdate();
        LOG.debug("delete {} access tokens for loginsession", (Object)deletedAccessTokens);
        Query queryDeleteRTokens = this.entityManager.createNamedQuery("DELETE_REFRESH_TOKEN_BY_LOGINSESSION");
        queryDeleteRTokens.setParameter("loginSession", (Object)loginSessionToken.getValue());
        int deletedRefreshTokens = queryDeleteRTokens.executeUpdate();
        LOG.debug("delete {} refresh tokens for loginsession", (Object)deletedRefreshTokens);
    }

    public boolean isValid(LoginSessionToken loginSessionToken) {
        LoginSessionEntity loginSessionEntity = (LoginSessionEntity)this.entityManager.find(LoginSessionEntity.class, (Object)loginSessionToken.getValue());
        if (loginSessionEntity == null) {
            return false;
        }
        return loginSessionEntity.getValid();
    }

    public void invalidateLoginSession(LoginSessionToken loginSessionToken) {
        LoginSessionEntity loginSessionEntity = (LoginSessionEntity)this.entityManager.find(LoginSessionEntity.class, (Object)loginSessionToken.getValue());
        if (loginSessionEntity != null) {
            loginSessionEntity.setValid(false);
        }
    }

    public UserInfo loadUserInfo(String id) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return tokenEntity == null ? null : tokenEntity.getUserInfo();
    }
}

