/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.LoginSessionToken;
import java.net.URI;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import net.minidev.json.JSONObject;

@Entity
@Table(name="AUTH_CODE_ENTITY")
public class AuthCodeEntity {
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="CREATED")
    private Date created;
    @Column(name="EXPIRES")
    private Date expires;
    @Lob
    @Column(name="USER_INFO")
    private String userInfo;
    @Column(name="CLIENT_ID")
    private String clientId;
    @Column(name="LOGIN_SESSION")
    private String loginSession;
    @Lob
    @Column(name="REDIRECT_URI")
    private String redirectUri;

    public AuthCodeEntity() {
    }

    public AuthCodeEntity(AuthorizationCode code, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId, URI redirectUri) {
        this.id = code.getValue();
        if (userInfo != null) {
            this.userInfo = userInfo.toJSONObject().toJSONString();
        }
        this.clientId = clientId.getValue();
        this.loginSession = sessionId != null ? sessionId.getValue() : null;
        this.redirectUri = redirectUri != null ? redirectUri.toString() : null;
    }

    @PrePersist
    public void onPrePersist() {
        if (this.created == null) {
            this.created = new Date();
        }
        if (this.expires == null) {
            this.expires = new Date(System.currentTimeMillis() + 60000L);
        }
    }

    public String toString() {
        return this.expires != null ? String.format("%1$Td.%1$Tm.%1$Ty-%1$TT.%1$TL %2$s", this.expires, this.id) : this.id;
    }

    private JSONObject getJSONObject(String value) {
        if (value == null) {
            return null;
        }
        try {
            return JSONObjectUtils.parse((String)value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid content " + e.getMessage());
        }
    }

    public UserInfo getUserInfo() {
        return this.userInfo == null ? null : new UserInfo(this.getJSONObject(this.userInfo));
    }

    public String getJsonUserInfo() {
        return this.userInfo;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getId() {
        return this.id;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getExpires() {
        return this.expires;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getLoginSession() {
        return this.loginSession;
    }
}

