/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.LoginSessionToken;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import net.minidev.json.JSONObject;

@Entity
@Table(name="TOKEN_ENTITY")
@NamedQueries(value={@NamedQuery(name="DELETE_ACCESS_TOKEN_BY_LOGINSESSION", query="delete from TokenEntity t where t.loginSession = :loginSession and t.refreshToken is not null"), @NamedQuery(name="DELETE_REFRESH_TOKEN_BY_LOGINSESSION", query="delete from TokenEntity t where t.loginSession = :loginSession and t.refreshToken is null")})
public class TokenEntity {
    static final String DELETE_ACCESS_TOKEN_BY_LOGINSESSION = "DELETE_ACCESS_TOKEN_BY_LOGINSESSION";
    static final String DELETE_REFRESH_TOKEN_BY_LOGINSESSION = "DELETE_REFRESH_TOKEN_BY_LOGINSESSION";
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="CREATED")
    private Date created;
    @Column(name="TOKEN")
    private String token;
    @Lob
    @Column(name="USER_INFO")
    private String userInfo;
    @Column(name="EXPIRES")
    private Date expires;
    @Column(name="CLIENT_ID")
    private String clientId;
    @Column(name="LOGIN_SESSION")
    private String loginSession;
    @ManyToOne
    private TokenEntity refreshToken;
    @OneToMany(mappedBy="refreshToken", cascade={CascadeType.REMOVE})
    private Collection<TokenEntity> accessTokens;

    public TokenEntity() {
    }

    public TokenEntity(Token token, UserInfo userInfo, ClientID clientId, LoginSessionToken sessionId) {
        this.id = token.getValue();
        this.token = token.toJSONObject().toJSONString();
        if (token instanceof AccessToken && 0L != ((AccessToken)token).getLifetime()) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, (int)((AccessToken)token).getLifetime());
            this.expires = cal.getTime();
        }
        if (userInfo != null) {
            this.userInfo = userInfo.toJSONObject().toJSONString();
        }
        if (clientId != null) {
            this.clientId = clientId.getValue();
        }
        if (sessionId != null) {
            this.loginSession = sessionId.getValue();
        }
    }

    @PrePersist
    public void onPrePersist() {
        if (this.created == null) {
            this.created = new Date();
        }
    }

    public AccessToken asAccessToken() {
        try {
            return BearerAccessToken.parse((JSONObject)this.getJSONObject(this.token));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RefreshToken asRefreshToken() {
        try {
            return RefreshToken.parse((JSONObject)this.getJSONObject(this.token));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JSONObject getJSONObject(String value) {
        if (value == null) {
            return null;
        }
        try {
            return JSONObjectUtils.parse((String)value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid content " + e.getMessage());
        }
    }

    public boolean isValid() {
        AccessToken accessToken = this.asAccessToken();
        if (accessToken != null) {
            return this.expires == null || System.currentTimeMillis() < this.expires.getTime();
        }
        return this.asRefreshToken() != null;
    }

    public String toString() {
        return this.expires != null ? String.format("%1$Td.%1$Tm.%1$Ty-%1$TT.%1$TL %2$s", this.expires, this.token) : this.token;
    }

    public UserInfo getUserInfo() {
        return this.userInfo == null ? null : new UserInfo(this.getJSONObject(this.userInfo));
    }

    public String getJsonUserInfo() {
        return this.userInfo;
    }

    public void setRefreshToken(TokenEntity refreshToken) {
        this.refreshToken = refreshToken;
    }

    public ClientID getClientId() {
        return new ClientID(this.clientId);
    }

    public void setLoginSession(String loginSession) {
        this.loginSession = loginSession;
    }

    public String getLoginSession() {
        return this.loginSession;
    }

    public LoginSessionToken getLoginSessionToken() {
        return this.loginSession == null ? null : new LoginSessionToken(this.loginSession);
    }
}

