/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JpaCleanup {
    private static final Logger LOG = LoggerFactory.getLogger(JpaCleanup.class);
    @PersistenceContext(unitName="oauth")
    private EntityManager entityManager;

    @Schedule(hour="1", persistent=false)
    public void doCleanup() {
        LocalDate nowMinus20 = LocalDate.now().minusDays(20L);
        Instant instant = nowMinus20.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        Date date = Date.from(instant);
        LOG.info("Cleaning up tokens older than: " + date);
        int countAuthCode = this.entityManager.createQuery("delete from AuthCodeEntity ace where ace.created < :date").setParameter("date", (Object)date).executeUpdate();
        LOG.info("Deleted " + countAuthCode + " AuthCodeEntities");
        int countToken = this.entityManager.createQuery("delete from TokenEntity te where te.created < :date").setParameter("date", (Object)date).executeUpdate();
        LOG.info("Deleted " + countToken + " TokenEntity");
        int countLoginSession = this.entityManager.createQuery("delete from LoginSessionEntity lse where lse.created < :date").setParameter("date", (Object)date).executeUpdate();
        LOG.info("Deleted " + countLoginSession + " LoginSessionEntity");
    }
}

