/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.LoginSessionToken;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import net.minidev.json.JSONObject;

@Entity
@Table(name="LOGIN_SESSION_ENTITY")
public class LoginSessionEntity {
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="CREATED")
    private Date created;
    @Lob
    @Column(name="USER_INFO")
    private String userInfo;
    @Column(name="VALID")
    private Boolean valid;

    public LoginSessionEntity() {
    }

    public LoginSessionEntity(LoginSessionToken token, UserInfo userInfo) {
        this.id = token.getValue();
        this.userInfo = userInfo.toJSONObject().toJSONString();
        this.valid = true;
    }

    @PrePersist
    public void onPrePersist() {
        if (this.created == null) {
            this.created = new Date();
        }
    }

    private JSONObject getJSONObject(String value) {
        if (value == null) {
            return null;
        }
        try {
            return JSONObjectUtils.parse((String)value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid content " + e.getMessage());
        }
    }

    public UserInfo getUserInfo() {
        return this.userInfo == null ? null : new UserInfo(this.getJSONObject(this.userInfo));
    }

    public String getJsonUserInfo() {
        return this.userInfo;
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }
}

