/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.tokenstore.jpa.TokenEntity;
import javax.ejb.Stateless;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class JpaTokenStore
implements TokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(JpaTokenStore.class);
    @PersistenceContext(unitName="oauth")
    private EntityManager entityManager;

    public String add(Token token, UserInfo userInfo, AuthorizationCode authCode) {
        this.entityManager.persist((Object)new TokenEntity(token, userInfo, authCode));
        return token.getValue();
    }

    public String add(Token token, UserInfo userInfo) {
        this.entityManager.persist((Object)new TokenEntity(token, userInfo));
        return token.getValue();
    }

    public void remove(String id) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.getReference(TokenEntity.class, (Object)id);
        if (tokenEntity != null) {
            this.entityManager.remove((Object)tokenEntity);
        }
    }

    public AccessToken load(String id) {
        Cache cache;
        if (LOG.isDebugEnabled() && (cache = this.entityManager.getEntityManagerFactory().getCache()).contains(TokenEntity.class, (Object)id)) {
            LOG.debug("read token from cache {}", (Object)id);
        }
        TokenEntity entity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return entity.asAccessToken();
    }

    public AccessToken load(AuthorizationCode authCode) {
        TypedQuery query = this.entityManager.createNamedQuery("FIND_ACCESSTOKEN", TokenEntity.class);
        query.setParameter(1, (Object)authCode.getValue());
        try {
            TokenEntity entity = (TokenEntity)query.getSingleResult();
            return entity.asAccessToken();
        }
        catch (Exception e) {
            LOG.error("no token available for {}", (Object)authCode.getValue());
            return null;
        }
    }

    public RefreshToken loadRefreshToken(String id) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return tokenEntity == null ? null : tokenEntity.asRefreshToken();
    }

    public boolean isValid(String id) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return tokenEntity != null && tokenEntity.isValid();
    }

    public UserInfo loadUserInfo(String id) {
        TokenEntity tokenEntity = (TokenEntity)this.entityManager.find(TokenEntity.class, (Object)id);
        return tokenEntity == null ? null : tokenEntity.getUserInfo();
    }
}

