/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.jpa;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import net.minidev.json.JSONObject;

@Entity
@Table(name="TOKEN_ENTITY")
@NamedQueries(value={@NamedQuery(name="FIND_ACCESSTOKEN", query="select t from TokenEntity t where authCode = ?1")})
public class TokenEntity {
    static final String FIND_ACCESSTOKEN = "FIND_ACCESSTOKEN";
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="CREATED")
    private Date created;
    @Column(name="TOKEN")
    private String token;
    @Column(name="USER_INFO", length=20000)
    private String userInfo;
    @Column(name="EXPIRES")
    private Date expires;
    @Column(name="AUTH_CODE")
    private String authCode;

    public TokenEntity() {
    }

    public TokenEntity(Token token, UserInfo userInfo) {
        this.id = token.getValue();
        this.token = token.toJSONObject().toJSONString();
        if (token instanceof AccessToken && 0L != ((AccessToken)token).getLifetime()) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, (int)((AccessToken)token).getLifetime());
            this.expires = cal.getTime();
        }
        if (userInfo != null) {
            this.userInfo = userInfo.toJSONObject().toJSONString();
        }
    }

    public TokenEntity(Token token, UserInfo userInfo, AuthorizationCode authCode) {
        this(token, userInfo);
        this.authCode = authCode != null ? authCode.getValue() : null;
    }

    @PrePersist
    public void onPrePersist() {
        if (this.created == null) {
            this.created = new Date();
        }
    }

    public AccessToken asAccessToken() {
        try {
            return BearerAccessToken.parse((JSONObject)this.getJSONObject(this.token));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RefreshToken asRefreshToken() {
        try {
            return RefreshToken.parse((JSONObject)this.getJSONObject(this.token));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JSONObject getJSONObject(String value) {
        if (value == null) {
            return null;
        }
        try {
            return JSONObjectUtils.parse((String)value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid content " + e.getMessage());
        }
    }

    public boolean isValid() {
        AccessToken accessToken = this.asAccessToken();
        if (accessToken != null) {
            return this.expires == null || System.currentTimeMillis() < this.expires.getTime();
        }
        return this.asRefreshToken() != null;
    }

    public String toString() {
        return this.expires != null ? String.format("%1$Td.%1$Tm.%1$Ty-%1$TT.%1$TL %2$s", this.expires, this.token) : this.token;
    }

    public UserInfo getUserInfo() {
        return this.userInfo == null ? null : new UserInfo(this.getJSONObject(this.userInfo));
    }

    public String getJsonUserInfo() {
        return this.userInfo;
    }

    public String getAuthCode() {
        return this.authCode;
    }
}

