/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.saml.idp.nl.surfnet.mujina;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.impl.AttributeBuilder;
import org.opensaml.saml2.core.impl.AttributeStatementBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;

public class AttributeStatementGenerator {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public AttributeStatement generateAttributeStatement(Map<String, String> attributes) {
        AttributeStatementBuilder attributeStatementBuilder = (AttributeStatementBuilder)this.builderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement attributeStatement = attributeStatementBuilder.buildObject();
        AttributeBuilder attributeBuilder = (AttributeBuilder)this.builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        XSStringBuilder stringBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            Attribute attribute = attributeBuilder.buildObject();
            attribute.setName(entry.getKey());
            String value = entry.getValue();
            if (StringUtils.isNotBlank((String)value)) {
                String[] split = StringUtils.split((String)value, (String)",");
                List<String> valueList = Arrays.asList(split);
                for (String v : valueList) {
                    XSString stringValue = (XSString)stringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
                    stringValue.setValue(v);
                    attribute.getAttributeValues().add(stringValue);
                }
            }
            attributeStatement.getAttributes().add(attribute);
        }
        return attributeStatement;
    }
}

