/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.saml.idp.nl.surfnet.mujina;

import de.adorsys.saml.idp.nl.surfnet.mujina.AttributeStatementGenerator;
import de.adorsys.saml.idp.nl.surfnet.mujina.AuthnStatementGenerator;
import de.adorsys.saml.idp.nl.surfnet.mujina.SubjectGenerator;
import java.util.HashMap;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;

public class AssertionGenerator {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private final SubjectGenerator subjectGenerator;
    private final AuthnStatementGenerator authnStatementGenerator = new AuthnStatementGenerator();
    private final AttributeStatementGenerator attributeStatementGenerator = new AttributeStatementGenerator();

    public AssertionGenerator(String issuingEntityName) {
        this.subjectGenerator = new SubjectGenerator();
    }

    public Assertion generateAssertion(String remoteIP, String userName, String roles, String recepientAssertionConsumerURL, int validForInSeconds, String inResponseTo, DateTime authnInstant, String idpUrl) {
        AssertionBuilder assertionBuilder = (AssertionBuilder)this.builderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = assertionBuilder.buildObject();
        Subject subject = this.subjectGenerator.generateSubject(recepientAssertionConsumerURL, validForInSeconds, userName, inResponseTo, remoteIP);
        Issuer responseIssuer = new IssuerBuilder().buildObject();
        responseIssuer.setValue(idpUrl);
        assertion.setIssuer(responseIssuer);
        AuthnStatement authnStatement = this.authnStatementGenerator.generateAuthnStatement(authnInstant);
        assertion.getAuthnStatements().add(authnStatement);
        assertion.setSubject(subject);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("urn:mace:dir:attribute-def:uid", userName);
        attributes.put("Membership", roles);
        assertion.getAttributeStatements().add(this.attributeStatementGenerator.generateAttributeStatement(attributes));
        assertion.setID(UUID.randomUUID().toString());
        assertion.setIssueInstant(new DateTime());
        return assertion;
    }
}

