/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.saml.idp;

import de.adorsys.saml.idp.DiksHttpPostEncoder;
import de.adorsys.saml.idp.nl.surfnet.mujina.AssertionGenerator;
import de.adorsys.saml.idp.nl.surfnet.mujina.StatusGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.app.VelocityEngine;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.metadata.AuthzService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.impl.AuthzServiceBuilder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.KeyStoreX509CredentialAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/*"})
public class IdpServlet
extends HttpServlet {
    private static final long serialVersionUID = -4726333893148785903L;
    private static final Logger LOG = LoggerFactory.getLogger(IdpServlet.class);
    private XMLObjectBuilderFactory builderFactory;
    private String idpUrl = "http://docker:8081/saml.idp";
    private String idpEntityName = "saml.idp";
    protected KeyStoreX509CredentialAdapter credential;
    private AssertionGenerator assertionGenerator;
    private StatusGenerator statusGenerator;
    private VelocityEngine velocityEngine;

    public void init() throws ServletException {
        super.init();
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
        this.builderFactory = Configuration.getBuilderFactory();
        this.initVelocityEngine();
        String keyStoreFile = "/opt/jboss/standalone/certs/saml.idp.keystore";
        String storeType = "jks";
        char[] keyStorePassword = "storepass".toCharArray();
        KeyStore keyStore = this.loadKeyStore(keyStoreFile, storeType, keyStorePassword);
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                LOG.debug("Key alias: " + alias);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        String signKeyAlias = this.idpEntityName;
        char[] signKeyPassword = "keypass".toCharArray();
        try {
            Key key = keyStore.getKey(signKeyAlias, signKeyPassword);
            if (key == null) {
                throw new IllegalStateException("can not read saml signing key. ");
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException(e);
        }
        this.credential = new KeyStoreX509CredentialAdapter(keyStore, signKeyAlias, signKeyPassword);
        this.assertionGenerator = new AssertionGenerator(this.idpEntityName);
        this.statusGenerator = new StatusGenerator();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BasicSAMLMessageContext inboundMessage = new BasicSAMLMessageContext();
        inboundMessage.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(req));
        HTTPPostDecoder decoder = new HTTPPostDecoder();
        try {
            decoder.decode((MessageContext)inboundMessage);
        }
        catch (MessageDecodingException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        AuthnRequest authnRequest = (AuthnRequest)inboundMessage.getInboundSAMLMessage();
        String assertionConsumerServiceURL = authnRequest.getAssertionConsumerServiceURL();
        Response authnResponse = this.generateAuthnResponse(assertionConsumerServiceURL, "adreas.boetscher", "GA_DIKS_STU_CM_BENUTZERKONTEN,XXXY", assertionConsumerServiceURL, 300, authnRequest.getID(), new DateTime());
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setInboundMessage((XMLObject)authnRequest);
        messageContext.setOutboundSAMLMessage((SAMLObject)authnResponse);
        messageContext.setOutboundSAMLMessageSigningCredential((Credential)this.credential);
        AuthzService endpoint = new AuthzServiceBuilder().buildObject();
        endpoint.setLocation(assertionConsumerServiceURL);
        messageContext.setPeerEntityEndpoint((Endpoint)endpoint);
        messageContext.setRelayState(inboundMessage.getRelayState());
        boolean secure = StringUtils.containsIgnoreCase((String)this.idpUrl, (String)"https://");
        HttpServletResponseAdapter responseAdapter = new HttpServletResponseAdapter(resp, secure);
        messageContext.setOutboundMessageTransport((OutTransport)responseAdapter);
        DiksHttpPostEncoder postEncoder = new DiksHttpPostEncoder(this.velocityEngine, "templates/saml2-post-binding.vm");
        try {
            postEncoder.encode((MessageContext)messageContext);
        }
        catch (MessageEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public Response generateAuthnResponse(String remoteIP, String userName, String roles, String recepientAssertionConsumerURL, int validForInSeconds, String inResponseTo, DateTime authnInstant) {
        ResponseBuilder responseBuilder = (ResponseBuilder)this.builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response authResponse = responseBuilder.buildObject();
        Issuer responseIssuer = new IssuerBuilder().buildObject();
        responseIssuer.setValue(this.idpUrl);
        Assertion assertion = this.assertionGenerator.generateAssertion(remoteIP, userName, roles, recepientAssertionConsumerURL, validForInSeconds, inResponseTo, authnInstant, this.idpUrl);
        authResponse.setIssuer(responseIssuer);
        authResponse.setID(UUID.randomUUID().toString());
        authResponse.setIssueInstant(new DateTime());
        authResponse.setInResponseTo(inResponseTo);
        authResponse.getAssertions().add(assertion);
        authResponse.setDestination(recepientAssertionConsumerURL);
        authResponse.setStatus(this.statusGenerator.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success"));
        return authResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore(String keyStorFile, String storeType, char[] keyStorePassword) {
        try {
            if (StringUtils.isBlank((String)storeType)) {
                storeType = KeyStore.getDefaultType();
            }
            KeyStore ks = KeyStore.getInstance(storeType);
            try (FileInputStream fis = null;){
                fis = new FileInputStream(keyStorFile);
                ks.load(fis, keyStorePassword);
            }
            return ks;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void initVelocityEngine() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("ISO-8859-1", (Object)"UTF-8");
        this.velocityEngine.setProperty("output.encoding", (Object)"UTF-8");
        this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
        this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        try {
            this.velocityEngine.init();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

