/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.saml.idp;

import org.apache.velocity.app.VelocityEngine;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiksHttpPostEncoder
extends HTTPPostEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(DiksHttpPostEncoder.class);

    public DiksHttpPostEncoder(VelocityEngine engine, String templateId) {
        super(engine, templateId);
    }

    protected void signMessage(SAMLMessageContext messageContext) throws MessageEncodingException {
        SAMLObject outboundSAML = messageContext.getOutboundSAMLMessage();
        Credential signingCredential = messageContext.getOuboundSAMLMessageSigningCredential();
        if (outboundSAML instanceof SignableSAMLObject && signingCredential != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)outboundSAML;
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential(signingCredential);
            try {
                DiksHttpPostEncoder.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null);
            }
            catch (SecurityException e) {
                throw new MessageEncodingException("Error preparing signature for signing", (Exception)((Object)e));
            }
            signableMessage.setSignature(signature);
            try {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                if (marshaller == null) {
                    throw new MessageEncodingException("No marshaller registered for " + signableMessage.getElementQName() + ", unable to marshall in preperation for signing");
                }
                marshaller.marshall((XMLObject)signableMessage);
                Signer.signObject((Signature)signature);
            }
            catch (MarshallingException e) {
                LOG.error("Unable to marshall protocol message in preparation for signing", (Throwable)e);
                throw new MessageEncodingException("Unable to marshall protocol message in preparation for signing", (Exception)((Object)e));
            }
            catch (SignatureException e) {
                LOG.error("Unable to sign protocol message", (Throwable)e);
                throw new MessageEncodingException("Unable to sign protocol message", (Exception)((Object)e));
            }
        }
    }

    protected void logEncodedMessage(MessageContext messageContext) {
        if (messageContext.getOutboundMessage() != null) {
            if (messageContext.getOutboundMessage().getDOM() == null) {
                try {
                    this.marshallMessage(messageContext.getOutboundMessage());
                }
                catch (MessageEncodingException e) {
                    LOG.error("Unable to marshall message for logging purposes: " + e.getMessage());
                    return;
                }
            }
            LOG.info("\n" + XMLHelper.prettyPrintXML((Node)messageContext.getOutboundMessage().getDOM()));
        }
    }

    public static void prepareSignatureParams(Signature signature, Credential signingCredential, SecurityConfiguration config) throws SecurityException {
        SecurityConfiguration secConfig = config != null ? config : Configuration.getGlobalSecurityConfiguration();
        String signAlgo = signature.getSignatureAlgorithm();
        if (signAlgo == null) {
            signAlgo = secConfig.getSignatureAlgorithmURI(signingCredential);
            signature.setSignatureAlgorithm(signAlgo);
        }
        if (SecurityHelper.isHMAC((String)signAlgo) && signature.getHMACOutputLength() == null) {
            signature.setHMACOutputLength(secConfig.getSignatureHMACOutputLength());
        }
        if (signature.getCanonicalizationAlgorithm() == null) {
            signature.setCanonicalizationAlgorithm(secConfig.getSignatureCanonicalizationAlgorithm());
        }
        if (signature.getKeyInfo() == null) {
            X509KeyInfoGeneratorFactory factory = new X509KeyInfoGeneratorFactory();
            factory.setEmitEntityCertificate(true);
            KeyInfoGenerator kiGenerator = factory.newInstance();
            if (kiGenerator != null) {
                try {
                    KeyInfo keyInfo = kiGenerator.generate(signingCredential);
                    signature.setKeyInfo(keyInfo);
                }
                catch (SecurityException e) {
                    LOG.error("Error generating KeyInfo from credential", (Throwable)e);
                    throw e;
                }
            } else {
                LOG.info("No KeyInfo will be generated for Signature");
            }
        }
    }
}

