/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.FixedServletUtils;
import de.adorsys.oauth.server.TokenStore;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/userinfo"})
@ApplicationScoped
public class UserInfoResource
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UserInfoResource.class);
    @Inject
    private TokenStore tokenStore;
    private Long cachemaxage;

    public void init(ServletConfig config) throws ServletException {
        try {
            this.cachemaxage = Long.valueOf(config.getServletContext().getInitParameter("cachemaxage"));
            LOG.info("cachemaxage {}", (Object)this.cachemaxage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.userInfo(req, resp);
    }

    public void userInfo(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        UserInfoRequest userInfoRequest;
        try {
            userInfoRequest = UserInfoRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(servletRequest));
        }
        catch (Exception e) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new UserInfoErrorResponse(BearerTokenError.INVALID_REQUEST).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        AccessToken accessToken = userInfoRequest.getAccessToken();
        if (!this.tokenStore.isValid(accessToken.getValue())) {
            LOG.info("expired token {}", (Object)accessToken.toJSONString());
            ServletUtils.applyHTTPResponse((HTTPResponse)new UserInfoErrorResponse(BearerTokenError.INVALID_TOKEN).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        UserInfo userInfo = this.tokenStore.loadUserInfo(accessToken.getValue());
        if (userInfo == null) {
            LOG.info("no userInfo available {}", (Object)accessToken.toJSONString());
            ServletUtils.applyHTTPResponse((HTTPResponse)new UserInfoErrorResponse(BearerTokenError.INVALID_TOKEN).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        LOG.debug("userInfo {}", (Object)accessToken.toJSONString());
        long lifeTime = this.tokenStore.load(accessToken.getValue()).getLifetime();
        long cacheLiveTime = this.cachemaxage != null ? this.cachemaxage : lifeTime;
        HTTPResponse httpResponse = new UserInfoSuccessResponse(userInfo).toHTTPResponse();
        httpResponse.setCacheControl("s-maxage=" + cacheLiveTime);
        ServletUtils.applyHTTPResponse((HTTPResponse)httpResponse, (HttpServletResponse)servletResponse);
    }
}

