/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.id.ClientID;
import de.adorsys.oauth.server.FixedServletUtils;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.TokenStore;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.FormParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/revoke"})
@ApplicationScoped
public class RevokeResource
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(RevokeResource.class);
    @Inject
    private TokenStore tokenStore;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String token = req.getParameter("token");
        String tokenTypeHint = req.getParameter("token_type_hint");
        this.revoke(token, tokenTypeHint, req, resp);
    }

    public void revoke(@FormParam(value="token") String token, @FormParam(value="token_type_hint") String tokenTypeHint, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (token == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.INVALID_GRANT).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        ClientID clientId = null;
        try {
            ClientAuthentication clientAuth = ClientAuthentication.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(servletRequest));
            if (clientAuth != null) {
                clientId = clientAuth.getClientID();
            }
        }
        catch (ParseException clientAuth) {
            // empty catch block
        }
        if ("login_session".equals(tokenTypeHint)) {
            LoginSessionToken loginSessionToken = new LoginSessionToken(token);
            this.tokenStore.remove(loginSessionToken);
            this.tokenStore.invalidateLoginSession(loginSessionToken);
        } else {
            this.tokenStore.remove(token, clientId);
        }
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setHeader("Content-Type", "text/plain");
        httpResponse.setHeader("Pragma", "no-cache");
        httpResponse.setHeader("Cache-Control", "no-store");
        ServletUtils.applyHTTPResponse((HTTPResponse)httpResponse, (HttpServletResponse)servletResponse);
    }
}

