/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.jose.util.Base64;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import de.adorsys.oauth.server.FixedServletUtils;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/api/token", "/api/revoke"}, dispatcherTypes={DispatcherType.REQUEST, DispatcherType.FORWARD})
public class ClientCredentialsCheckFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCredentialsCheckFilter.class);
    private String clientSecurityDomain = "client-auth";
    private boolean checkClientCredentialsOnTokenRevoke;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.clientSecurityDomain = filterConfig.getServletContext().getInitParameter("clientCredentialsSecurityDomain");
        if (this.clientSecurityDomain == null) {
            this.clientSecurityDomain = "client-auth";
        }
        this.checkClientCredentialsOnTokenRevoke = !"false".equals(filterConfig.getServletContext().getInitParameter("checkClientCredentialsOnTokenRevoke"));
    }

    public void doFilter(ServletRequest sr, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)sr;
        HttpServletResponse response = (HttpServletResponse)sresp;
        if (!this.verifyClientCredentials(request)) {
            response.setStatus(401);
            response.setHeader("WWW-Authenticate", "Basic realm=\"oauth\"");
            response.getWriter().write("client authentification failed");
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    private boolean verifyClientCredentials(HttpServletRequest httpRequest) throws IOException {
        ClientAuthentication clientAuth;
        if (httpRequest.getRequestURI().endsWith("/api/revoke") && !this.checkClientCredentialsOnTokenRevoke) {
            return true;
        }
        try {
            clientAuth = ClientAuthentication.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(httpRequest));
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        if (!(clientAuth instanceof PlainClientSecret)) {
            return false;
        }
        final PlainClientSecret plainClientSecret = (PlainClientSecret)clientAuth;
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(plainClientSecret.getClientID().getValue());
                        continue;
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callback).setPassword(plainClientSecret.getClientSecret().getValue().toCharArray());
                }
            }
        };
        Subject subject = new Subject();
        try {
            LoginContext loginContext = new LoginContext(this.clientSecurityDomain, subject, callbackHandler);
            loginContext.login();
            loginContext.logout();
        }
        catch (LoginException e) {
            LOG.error("call securitydomain " + callbackHandler, (Throwable)e);
            return false;
        }
        return true;
    }

    private String[] getNamePassword(HttpServletRequest httpRequest) {
        String authValue = httpRequest.getHeader("Authorization");
        if (authValue != null && authValue.startsWith("Basic ")) {
            String[] stringArray;
            String encodedValue = authValue.substring(6);
            String decodedValue = new Base64(encodedValue).decodeToString();
            if (decodedValue.contains(":")) {
                stringArray = decodedValue.split(":");
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = decodedValue;
                stringArray = stringArray2;
                stringArray2[1] = "";
            }
            String[] namePassword = stringArray;
            return namePassword;
        }
        if (httpRequest.getContentType().contains("application/x-www-form-urlencoded")) {
            String clientId = httpRequest.getParameter("client_id");
            String clientSecret = httpRequest.getParameter("client_secret");
            if (clientId == null || clientSecret == null) {
                return null;
            }
            return new String[]{clientId, clientSecret};
        }
        return null;
    }
}

