/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.LoginSessionAuthorizationSuccessResponse;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.OAuthException;
import de.adorsys.oauth.server.RememberMeCookieUtil;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.server.UserInfoFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/auth"})
@ApplicationScoped
public class AuthResource
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AuthResource.class);
    private static final String CLIENT_ID_STR = "client_id";
    @Inject
    private UserInfoFactory userInfoFactory;
    @Inject
    private TokenStore tokenStore;
    private long tokenLifetime;

    public void init(ServletConfig config) throws ServletException {
        try {
            this.tokenLifetime = Long.valueOf(config.getServletContext().getInitParameter("lifetime"));
        }
        catch (Exception e) {
            this.tokenLifetime = 28800L;
        }
        LOG.info("token lifetime {}", (Object)this.tokenLifetime);
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse resp) throws ServletException, IOException {
        this.authorize(servletRequest, resp);
    }

    private void authorize(HttpServletRequest servletRequest, HttpServletResponse resp) throws IOException {
        HTTPResponse response;
        UserInfo userInfo;
        LoginSessionToken loginSession;
        AuthorizationRequest request;
        try {
            request = this.resolveAuthorizationRequest(servletRequest);
        }
        catch (ParseException e) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.INVALID_REQUEST).toHTTPResponse(), (HttpServletResponse)resp);
            return;
        }
        URI redirectionURI = request.getRedirectionURI();
        if (redirectionURI == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new AuthorizationErrorResponse(request.getEndpointURI(), OAuth2Error.INVALID_REQUEST, request.getState(), request.getResponseMode()).toHTTPResponse(), (HttpServletResponse)resp);
            return;
        }
        if (servletRequest.getUserPrincipal() == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new AuthorizationErrorResponse(redirectionURI, OAuth2Error.UNAUTHORIZED_CLIENT, request.getState(), request.getResponseMode()).toHTTPResponse(), (HttpServletResponse)resp);
            return;
        }
        if (request.getClientID() == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new AuthorizationErrorResponse(redirectionURI, OAuth2Error.INVALID_CLIENT, request.getState(), request.getResponseMode()).toHTTPResponse(), (HttpServletResponse)resp);
        }
        if (request.getResponseType() == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new AuthorizationErrorResponse(redirectionURI, OAuth2Error.UNSUPPORTED_RESPONSE_TYPE, request.getState(), request.getResponseMode()).toHTTPResponse(), (HttpServletResponse)resp);
        }
        if ((loginSession = (LoginSessionToken)((Object)servletRequest.getAttribute("loginSession"))) != null && RememberMeCookieUtil.getCookieToken(servletRequest, request.getClientID()) != null && !this.tokenStore.isValid(loginSession)) {
            servletRequest.removeAttribute("loginSession");
            this.tokenStore.removeLoginSession(loginSession);
            HTTPResponse httpResponse = new HTTPResponse(303);
            httpResponse.setLocation(request.toURI());
            ServletUtils.applyHTTPResponse((HTTPResponse)httpResponse, (HttpServletResponse)resp);
            return;
        }
        if (loginSession != null) {
            userInfo = this.tokenStore.loadUserInfoFromLoginSession(loginSession);
            if (userInfo == null) {
                userInfo = this.userInfoFactory.createUserInfo(servletRequest);
                this.tokenStore.addLoginSession(loginSession, userInfo);
            }
        } else {
            userInfo = this.userInfoFactory.createUserInfo(servletRequest);
        }
        LOG.debug(userInfo.toJSONObject().toJSONString());
        BearerAccessToken accessToken = new BearerAccessToken(this.tokenLifetime, request.getScope());
        if (request.getResponseType().impliesCodeFlow()) {
            AuthorizationCode authCode = new AuthorizationCode();
            LOG.debug("impliesCodeFlow {}", (Object)authCode.toJSONString());
            this.tokenStore.addAuthCode(authCode, userInfo, request.getClientID(), loginSession, redirectionURI);
            response = new AuthorizationSuccessResponse(redirectionURI, authCode, null, request.getState(), request.getResponseMode()).toHTTPResponse();
        } else {
            LOG.debug("impliesTokenFlow {}", (Object)accessToken.toJSONString());
            this.tokenStore.addAccessToken(accessToken, userInfo, request.getClientID(), null);
            URI cleanUrl = this.getCleanUrl(redirectionURI);
            response = new LoginSessionAuthorizationSuccessResponse(cleanUrl, null, (AccessToken)accessToken, request.getState(), request.getResponseMode(), loginSession, redirectionURI.getFragment()).toHTTPResponse();
        }
        LOG.debug("location {}", (Object)response.getHeader("location"));
        ServletUtils.applyHTTPResponse((HTTPResponse)response, (HttpServletResponse)resp);
    }

    private URI getCleanUrl(URI redirectionURI) {
        URI cleanUrl;
        String fragmentsOfSpa = redirectionURI.getFragment();
        try {
            cleanUrl = new URI(redirectionURI.toString().replace("#" + fragmentsOfSpa, ""));
        }
        catch (URISyntaxException e) {
            throw new OAuthException("clean url cant be parsed", null);
        }
        return cleanUrl;
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse resp) throws ServletException, IOException {
        this.authorize(servletRequest, resp);
    }

    private AuthorizationRequest resolveAuthorizationRequest(HttpServletRequest servletRequest) throws ParseException {
        if (this.isNotBlank(servletRequest.getParameter(CLIENT_ID_STR))) {
            return AuthorizationRequest.parse((URI)this.extractURI(servletRequest), this.requestParameters(servletRequest));
        }
        if (this.contains(servletRequest.getQueryString(), CLIENT_ID_STR)) {
            return AuthorizationRequest.parse((URI)this.extractURI(servletRequest), (String)servletRequest.getQueryString());
        }
        if (servletRequest.getParameter("SAMLResponse") != null && servletRequest.getParameter("RelayState") != null) {
            try {
                URL url = new URL(servletRequest.getParameter("RelayState"));
                if (this.contains(url.getQuery(), CLIENT_ID_STR)) {
                    return AuthorizationRequest.parse((String)url.getQuery());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException(String.format("unable to resolve AuthorizationRequest from %s", servletRequest.getRequestURI()));
    }

    private boolean contains(String queryString, String searchStr) {
        return queryString != null && queryString.contains(searchStr);
    }

    private boolean isNotBlank(String parameter) {
        return parameter != null && parameter.trim().length() > 0;
    }

    public Map<String, String> requestParameters(HttpServletRequest servletRequest) {
        Enumeration parameterNames = servletRequest.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
            String value = servletRequest.getParameter(param);
            params.put(param, value);
        }
        return params;
    }

    private URI extractURI(HttpServletRequest request) {
        try {
            String query = request.getQueryString() == null ? "" : "?" + request.getQueryString();
            return new URL(request.getScheme(), request.getServerName(), request.getServerPort(), request.getRequestURI()).toURI();
        }
        catch (Exception e) {
            LOG.warn("Error extracting auth/ URI: " + e.getMessage());
            return null;
        }
    }
}

