/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.AuthCodeAndMetadata;
import de.adorsys.oauth.server.FixedServletUtils;
import de.adorsys.oauth.server.RefreshTokenAndMetadata;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.server.UserInfoFactory;
import java.io.IOException;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/token"})
@ApplicationScoped
public class TokenResource
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TokenResource.class);
    @Inject
    private UserInfoFactory userInfoFactory;
    @Inject
    private TokenStore tokenStore;
    private long tokenLifetime;

    public void init(ServletConfig config) throws ServletException {
        try {
            this.tokenLifetime = Long.valueOf(config.getServletContext().getInitParameter("lifetime"));
        }
        catch (Exception e) {
            this.tokenLifetime = 28800L;
        }
        LOG.info("token lifetime {}", (Object)this.tokenLifetime);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.token(req, resp);
    }

    public void token(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        TokenRequest request;
        try {
            request = TokenRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(servletRequest));
        }
        catch (ParseException e) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.UNSUPPORTED_GRANT_TYPE).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        LOG.debug("tokenRequest {}", (Object)request);
        AuthorizationGrant authorizationGrant = request.getAuthorizationGrant();
        if (authorizationGrant.getType() == GrantType.AUTHORIZATION_CODE) {
            this.doAuthorizationCodeGrantFlow(request, servletRequest, servletResponse);
            return;
        }
        if (authorizationGrant.getType() == GrantType.PASSWORD) {
            this.doResourceOwnerPasswordCredentialFlow(request, servletRequest, servletResponse);
            return;
        }
        if (authorizationGrant.getType() == GrantType.REFRESH_TOKEN) {
            this.doRefreshTokenGrantFlow(request, servletRequest, servletResponse);
            return;
        }
        ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.UNSUPPORTED_GRANT_TYPE).toHTTPResponse(), (HttpServletResponse)servletResponse);
    }

    private void doRefreshTokenGrantFlow(TokenRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        RefreshTokenGrant refreshTokenGrant = (RefreshTokenGrant)request.getAuthorizationGrant();
        RefreshTokenAndMetadata refreshTokeMetadata = this.tokenStore.findRefreshToken(refreshTokenGrant.getRefreshToken());
        if (refreshTokeMetadata == null || !refreshTokeMetadata.getClientId().equals((Object)request.getClientAuthentication().getClientID())) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.INVALID_GRANT).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        RefreshToken refreshToken = new RefreshToken();
        this.tokenStore.addRefreshToken(refreshToken, refreshTokeMetadata.getUserInfo(), refreshTokeMetadata.getClientId(), refreshTokeMetadata.getLoginSession());
        BearerAccessToken accessToken = new BearerAccessToken(this.tokenLifetime, request.getScope());
        this.tokenStore.addAccessToken(accessToken, refreshTokeMetadata.getUserInfo(), refreshTokeMetadata.getClientId(), refreshToken);
        this.tokenStore.remove(refreshTokeMetadata.getRefreshToken().getValue(), refreshTokeMetadata.getClientId());
        ServletUtils.applyHTTPResponse((HTTPResponse)new AccessTokenResponse(new Tokens((AccessToken)accessToken, refreshToken)).toHTTPResponse(), (HttpServletResponse)servletResponse);
    }

    private void doAuthorizationCodeGrantFlow(TokenRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)request.getAuthorizationGrant();
        AuthCodeAndMetadata authCodeMetadata = this.tokenStore.consumeAuthCode(authorizationCodeGrant.getAuthorizationCode());
        if (authCodeMetadata == null || !authCodeMetadata.getClientId().equals((Object)request.getClientAuthentication().getClientID()) || !authCodeMetadata.getRedirectURI().equals(servletRequest.getParameter("redirect_uri"))) {
            LOG.info("tokenRequest: invalid grant {}", (Object)authorizationCodeGrant.getAuthorizationCode());
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.INVALID_GRANT).toHTTPResponse(), (HttpServletResponse)servletResponse);
            return;
        }
        RefreshToken refreshToken = new RefreshToken();
        this.tokenStore.addRefreshToken(refreshToken, authCodeMetadata.getUserInfo(), authCodeMetadata.getClientId(), authCodeMetadata.getLoginSession());
        BearerAccessToken accessToken = new BearerAccessToken(this.tokenLifetime, request.getScope());
        this.tokenStore.addAccessToken(accessToken, authCodeMetadata.getUserInfo(), authCodeMetadata.getClientId(), refreshToken);
        LOG.debug("accessToken {}", (Object)accessToken.toJSONString());
        HashMap<String, String> customParameters = new HashMap<String, String>();
        if (authCodeMetadata.getLoginSession() != null) {
            customParameters.put("login_session", authCodeMetadata.getLoginSession().getValue());
        }
        ServletUtils.applyHTTPResponse((HTTPResponse)new AccessTokenResponse(new Tokens((AccessToken)accessToken, refreshToken), customParameters).toHTTPResponse(), (HttpServletResponse)servletResponse);
    }

    private void doResourceOwnerPasswordCredentialFlow(TokenRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        UserInfo userInfo = this.userInfoFactory.createUserInfo(servletRequest);
        LOG.debug(userInfo.toJSONObject().toJSONString());
        RefreshToken refreshToken = new RefreshToken();
        LOG.debug("request.getClientAuthentication() {}", (Object)request.getClientAuthentication());
        this.tokenStore.addRefreshToken(refreshToken, userInfo, request.getClientAuthentication().getClientID(), null);
        BearerAccessToken accessToken = new BearerAccessToken(this.tokenLifetime, request.getScope());
        LOG.debug("resourceOwnerPasswordCredentialFlow {}", (Object)accessToken.toJSONString());
        this.tokenStore.addAccessToken(accessToken, userInfo, request.getClientAuthentication().getClientID(), refreshToken);
        LOG.debug("accessToken {}", (Object)accessToken.toJSONString());
        ServletUtils.applyHTTPResponse((HTTPResponse)new AccessTokenResponse(new Tokens((AccessToken)accessToken, refreshToken)).toHTTPResponse(), (HttpServletResponse)servletResponse);
    }
}

