/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import de.adorsys.oauth.server.RememberMeCookieUtil;
import de.adorsys.oauth.server.RememberMeTokenUtil;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RememberMeLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(RememberMeLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private Collection<Principal> preparedPrincipals;
    HttpServletRequest request;
    HttpServletResponse response;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        try {
            this.request = (HttpServletRequest)PolicyContext.getContext((String)HttpServletRequest.class.getName());
        }
        catch (PolicyContextException e) {
            e.printStackTrace();
        }
        try {
            this.response = (HttpServletResponse)PolicyContext.getContext((String)HttpServletResponse.class.getName());
        }
        catch (PolicyContextException e) {
            e.printStackTrace();
        }
        if (this.request == null) {
            LOG.error("PolicyContext.getContext(HttpServletRequest.class.getName()) null");
        }
        if (this.response == null) {
            LOG.error("PolicyContext.getContext(HttpServletResponse.class.getName() null");
        }
    }

    @Override
    public boolean login() throws LoginException {
        AuthorizationRequest authorizationRequest;
        if (!this.request.getRequestURI().endsWith("/auth")) {
            return false;
        }
        try {
            authorizationRequest = AuthorizationRequest.parse((String)this.request.getQueryString());
        }
        catch (ParseException e) {
            return false;
        }
        Cookie serializedToken = RememberMeCookieUtil.getCookieToken(this.request, authorizationRequest.getClientID());
        if (serializedToken != null) {
            this.preparedPrincipals = RememberMeTokenUtil.deserialize(serializedToken.getValue());
            if (this.preparedPrincipals == null) {
                RememberMeCookieUtil.removeCookieToken(this.request, this.response, authorizationRequest.getClientID());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.preparedPrincipals != null) {
            this.subject.getPrincipals().addAll(this.preparedPrincipals);
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject = null;
        this.preparedPrincipals = null;
        return true;
    }
}

