/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import de.adorsys.oauth.server.JBossSubjectInfo;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.OAuthException;
import de.adorsys.oauth.server.RememberMeCookieUtil;
import de.adorsys.oauth.server.RememberMeTokenUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SubjectInfo;
import org.jboss.security.identity.Role;

@WebFilter(filterName="rememberme")
public class RememberMeFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest sr, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        AuthorizationRequest authorizationRequest;
        HttpServletRequest request = (HttpServletRequest)sr;
        HttpServletResponse response = (HttpServletResponse)sresp;
        try {
            authorizationRequest = AuthorizationRequest.parse((String)request.getQueryString());
        }
        catch (ParseException e) {
            throw new OAuthException("problem extraction clientId", e);
        }
        if (RememberMeTokenUtil.isEnabled() && this.shouldRememberMe(request)) {
            request.setAttribute("loginSession", (Object)this.getOrCreateLoginSession(request, response, authorizationRequest));
        }
        chain.doFilter(sr, sresp);
        if (request.getAttribute("loginSession") == null) {
            RememberMeCookieUtil.removeCookieToken(request, response, authorizationRequest.getClientID());
        }
    }

    private boolean shouldRememberMe(HttpServletRequest request) {
        return !"false".equals(request.getParameter("rememberme"));
    }

    private LoginSessionToken getOrCreateLoginSession(HttpServletRequest request, HttpServletResponse response, AuthorizationRequest authorizationRequest) {
        LoginSessionToken loginSession;
        Cookie cookieToken = RememberMeCookieUtil.getCookieToken(request, authorizationRequest.getClientID());
        if (cookieToken == null) {
            loginSession = new LoginSessionToken();
            this.rememberAuthInCookie(request, response, authorizationRequest.getClientID(), loginSession);
        } else {
            loginSession = RememberMeTokenUtil.getLoginSession(cookieToken.getValue());
        }
        return loginSession;
    }

    private void rememberAuthInCookie(HttpServletRequest request, HttpServletResponse response, ClientID clientID, LoginSessionToken loginSessionToken) {
        String callerPrincipal = request.getUserPrincipal().getName();
        SecurityContext context = SecurityContextAssociation.getSecurityContext();
        SubjectInfo subjectInfo = context.getSubjectInfo();
        Collection<Role> roles = new JBossSubjectInfo(subjectInfo).getRoles();
        ArrayList<String> roleStrings = new ArrayList<String>();
        for (Role role : roles) {
            roleStrings.add(role.getRoleName());
        }
        String encryptedToken = RememberMeTokenUtil.serialize(loginSessionToken, callerPrincipal, roleStrings);
        RememberMeCookieUtil.setLoginSessionCookie(request, response, encryptedToken, clientID);
    }

    public void destroy() {
    }
}

