/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.OAuthException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class LoginSessionAuthorizationSuccessResponse
extends AuthorizationSuccessResponse {
    private LoginSessionToken loginSession;
    private String originalFragment;

    public LoginSessionAuthorizationSuccessResponse(URI redirectURI, AuthorizationCode code, AccessToken accessToken, State state, ResponseMode rm, LoginSessionToken loginSession, String originalFragment) {
        super(redirectURI, code, accessToken, state, rm);
        this.loginSession = loginSession;
        this.originalFragment = originalFragment;
    }

    public Map<String, String> toParameters() {
        Map parameters = super.toParameters();
        if (this.loginSession != null) {
            parameters.put("login_session", this.loginSession.getValue());
        }
        return parameters;
    }

    public URI toURI() {
        if (this.originalFragment == null) {
            return super.toURI();
        }
        String uri = super.toURI().toString();
        uri = uri.replace("#", "#" + this.originalFragment + "?");
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new OAuthException("failed to construct new redirect url", e);
        }
    }
}

