/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.FixedServletUtils;
import de.adorsys.oauth.server.TokenStore;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="userinfo")
@ApplicationScoped
public class UserInfoResource {
    private static final Logger LOG = LoggerFactory.getLogger(UserInfoResource.class);
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private HttpServletResponse servletResponse;
    @Inject
    private TokenStore tokenStore;

    @GET
    public void userInfo() throws Exception {
        UserInfoRequest userInfoRequest;
        try {
            userInfoRequest = UserInfoRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(this.servletRequest));
        }
        catch (Exception e) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new UserInfoErrorResponse(BearerTokenError.INVALID_REQUEST).toHTTPResponse(), (HttpServletResponse)this.servletResponse);
            return;
        }
        AccessToken accessToken = userInfoRequest.getAccessToken();
        LOG.info("userInfo {}", (Object)accessToken.toJSONString());
        UserInfo userInfo = this.tokenStore.loadUserInfo(accessToken.getValue());
        if (userInfo == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new UserInfoErrorResponse(BearerTokenError.INVALID_TOKEN).toHTTPResponse(), (HttpServletResponse)this.servletResponse);
            return;
        }
        long lifeTime = this.tokenStore.load(accessToken.getValue()).getLifetime();
        HTTPResponse httpResponse = new UserInfoSuccessResponse(userInfo).toHTTPResponse();
        httpResponse.setCacheControl("s-maxage=" + lifeTime);
        ServletUtils.applyHTTPResponse((HTTPResponse)httpResponse, (HttpServletResponse)this.servletResponse);
    }
}

