/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SubjectInfo;
import org.jboss.security.identity.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class UserInfoFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UserInfoFactory.class);
    @Inject
    private Principal principal;

    public UserInfo createUserInfo(HttpServletRequest servletRequest) {
        Object object = servletRequest.getAttribute("userInfo");
        if (object != null && object instanceof UserInfo) {
            return (UserInfo)object;
        }
        SecurityContext context = SecurityContextAssociation.getSecurityContext();
        SubjectInfo subjectInfo = context.getSubjectInfo();
        String name = this.principal.getName();
        ArrayList<String> roles = new ArrayList<String>();
        UserInfo userInfo = new UserInfo(new Subject(name));
        userInfo.setName(name);
        if (subjectInfo.getRoles() != null) {
            for (Role role : subjectInfo.getRoles().getRoles()) {
                roles.add(role.getRoleName());
            }
            userInfo.setClaim("groups", roles);
        }
        this.addCustomGroups(userInfo, subjectInfo.getAuthenticatedSubject().getPrincipals());
        return userInfo;
    }

    public void addCustomGroups(UserInfo userInfo, Set<Principal> principals) {
        if (userInfo == null || principals == null) {
            LOG.error("Userinfo or Principals null");
            return;
        }
        List<Group> unknownGroups = this.getUnknownGroups(principals);
        for (Group prince : unknownGroups) {
            Principal other = (Principal)prince.members().nextElement();
            userInfo.setClaim(prince.getName(), (Object)other.toString());
        }
    }

    private List<Group> getUnknownGroups(Set<Principal> principals) {
        ArrayList<Group> groups = new ArrayList<Group>();
        block8: for (Principal principal : principals) {
            if (!(principal instanceof Group)) continue;
            switch (principal.getClass().getName()) {
                case "org.glassfish.security.common.Group": 
                case "org.apache.geronimo.security.realm.providers.GeronimoGroupPrincipal": 
                case "weblogic.security.principal.WLSGroupImpl": {
                    continue block8;
                }
            }
            if (principal.getName().equals("Roles") || principal.getName().equals("CallerPrincipal")) continue;
            groups.add((Group)principal);
        }
        return groups;
    }
}

