/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.FixedServletUtils;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.server.UserInfoFactory;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="token")
@ApplicationScoped
public class TokenResource {
    private static final Logger LOG = LoggerFactory.getLogger(TokenResource.class);
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private HttpServletResponse servletResponse;
    @Context
    private ServletContext servletContext;
    @Inject
    private UserInfoFactory userInfoFactory;
    @Inject
    private TokenStore tokenStore;
    private long tokenLifetime;

    @PostConstruct
    public void postConstruct() {
        try {
            this.tokenLifetime = Long.valueOf(this.servletContext.getInitParameter("lifetime"));
        }
        catch (Exception e) {
            this.tokenLifetime = 28800L;
        }
        LOG.info("token lifetime {}", (Object)this.tokenLifetime);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void token() throws Exception {
        TokenRequest request = TokenRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(this.servletRequest));
        LOG.info("tokenRequest {}", (Object)request);
        AuthorizationGrant authorizationGrant = request.getAuthorizationGrant();
        if (authorizationGrant.getType() == GrantType.AUTHORIZATION_CODE) {
            this.doAuthorizationCodeGrantFlow(authorizationGrant);
            return;
        }
        if (authorizationGrant.getType() == GrantType.PASSWORD) {
            this.doResourceOwnerPasswordCredentialFlow(request);
            return;
        }
        ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.UNSUPPORTED_GRANT_TYPE).toHTTPResponse(), (HttpServletResponse)this.servletResponse);
    }

    private void doAuthorizationCodeGrantFlow(AuthorizationGrant authorizationGrant) throws Exception {
        AuthorizationCodeGrant authorizationCodeGrant = (AuthorizationCodeGrant)authorizationGrant;
        AccessToken accessToken = this.tokenStore.load(authorizationCodeGrant.getAuthorizationCode());
        if (accessToken == null) {
            LOG.info("tokenRequest: invalid grant {}", (Object)authorizationCodeGrant.getAuthorizationCode());
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.INVALID_GRANT).toHTTPResponse(), (HttpServletResponse)this.servletResponse);
            return;
        }
        RefreshToken refreshToken = new RefreshToken();
        UserInfo userInfo = this.tokenStore.loadUserInfo(accessToken.getValue());
        this.tokenStore.add((Token)refreshToken, userInfo);
        LOG.info("accessToken {}", (Object)accessToken.toJSONString());
        ServletUtils.applyHTTPResponse((HTTPResponse)new AccessTokenResponse(new Tokens(accessToken, refreshToken)).toHTTPResponse(), (HttpServletResponse)this.servletResponse);
    }

    private void doResourceOwnerPasswordCredentialFlow(TokenRequest request) throws Exception {
        UserInfo userInfo = this.userInfoFactory.createUserInfo(this.servletRequest);
        LOG.debug(userInfo.toJSONObject().toJSONString());
        BearerAccessToken accessToken = new BearerAccessToken(this.tokenLifetime, request.getScope());
        LOG.info("resourceOwnerPasswordCredentialFlow {}", (Object)accessToken.toJSONString());
        this.tokenStore.add((Token)accessToken, userInfo);
        RefreshToken refreshToken = new RefreshToken();
        this.tokenStore.add((Token)refreshToken, userInfo);
        LOG.info("accessToken {}", (Object)accessToken.toJSONString());
        ServletUtils.applyHTTPResponse((HTTPResponse)new AccessTokenResponse(new Tokens((AccessToken)accessToken, refreshToken)).toHTTPResponse(), (HttpServletResponse)this.servletResponse);
    }
}

