/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import de.adorsys.oauth.server.TokenStore;
import de.adorsys.oauth.server.UserInfoFactory;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="auth")
@ApplicationScoped
public class AuthResource {
    private static final Logger LOG = LoggerFactory.getLogger(AuthResource.class);
    private static final String CLIENT_ID_STR = "client_id";
    @Context
    private HttpServletRequest servletRequest;
    @Context
    private ServletContext servletContext;
    @Inject
    private UserInfoFactory userInfoFactory;
    @Inject
    private TokenStore tokenStore;
    private long tokenLifetime;

    @PostConstruct
    public void postConstruct() {
        try {
            this.tokenLifetime = Long.valueOf(this.servletContext.getInitParameter("lifetime"));
        }
        catch (Exception e) {
            this.tokenLifetime = 28800L;
        }
        LOG.info("token lifetime {}", (Object)this.tokenLifetime);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizePost() throws Exception {
        AuthorizationRequest request = this.resolveAuthorizationRequest();
        Response.ResponseBuilder response = Response.status((int)302).header("Authorization", null);
        if (request.getRedirectionURI() == null) {
            return response.location(new AuthorizationErrorResponse(request.getEndpointURI(), OAuth2Error.INVALID_REQUEST, request.getState(), request.getResponseMode()).toURI()).build();
        }
        if (this.servletRequest.getUserPrincipal() == null) {
            return response.location(new AuthorizationErrorResponse(request.getRedirectionURI(), OAuth2Error.UNAUTHORIZED_CLIENT, request.getState(), request.getResponseMode()).toURI()).build();
        }
        if (request.getClientID() == null) {
            return response.location(new AuthorizationErrorResponse(request.getRedirectionURI(), OAuth2Error.INVALID_CLIENT, request.getState(), request.getResponseMode()).toURI()).build();
        }
        if (request.getResponseType() == null) {
            return response.location(new AuthorizationErrorResponse(request.getRedirectionURI(), OAuth2Error.UNSUPPORTED_RESPONSE_TYPE, request.getState(), request.getResponseMode()).toURI()).build();
        }
        UserInfo userInfo = this.userInfoFactory.createUserInfo(this.servletRequest);
        LOG.debug(userInfo.toJSONObject().toJSONString());
        BearerAccessToken accessToken = new BearerAccessToken(this.tokenLifetime, request.getScope());
        if (request.getResponseType().impliesCodeFlow()) {
            AuthorizationCode authCode = new AuthorizationCode();
            LOG.info("impliesCodeFlow {}", (Object)authCode.toJSONString());
            this.tokenStore.add((Token)accessToken, userInfo, authCode);
            return response.location(new AuthorizationSuccessResponse(request.getRedirectionURI(), authCode, null, request.getState(), request.getResponseMode()).toURI()).build();
        }
        LOG.info("impliesTokenFlow {}", (Object)accessToken.toJSONString());
        this.tokenStore.add((Token)accessToken, userInfo);
        AuthorizationSuccessResponse successResponse = new AuthorizationSuccessResponse(request.getRedirectionURI(), null, (AccessToken)accessToken, request.getState(), request.getResponseMode());
        String location = successResponse.toURI().toString();
        LOG.info("location {}", (Object)location);
        return response.location(new URI(location)).build();
    }

    @GET
    public Response authorizeGet() throws Exception {
        return this.authorizePost();
    }

    private AuthorizationRequest resolveAuthorizationRequest() throws ParseException {
        if (this.isNotBlank(this.servletRequest.getParameter(CLIENT_ID_STR))) {
            return AuthorizationRequest.parse(this.requestParameters(this.servletRequest));
        }
        if (this.contains(this.servletRequest.getQueryString(), CLIENT_ID_STR)) {
            return AuthorizationRequest.parse((String)this.servletRequest.getQueryString());
        }
        if (this.servletRequest.getParameter("SAMLResponse") != null && this.servletRequest.getParameter("RelayState") != null) {
            try {
                URL url = new URL(this.servletRequest.getParameter("RelayState"));
                if (this.contains(url.getQuery(), CLIENT_ID_STR)) {
                    return AuthorizationRequest.parse((String)url.getQuery());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException(String.format("unable to resolve AuthorizationRequest from %s", this.servletRequest.getRequestURI()));
    }

    private boolean contains(String queryString, String searchStr) {
        return queryString != null && queryString.contains(searchStr);
    }

    private boolean isNotBlank(String parameter) {
        return parameter != null && parameter.trim().length() > 0;
    }

    public Map<String, String> requestParameters(HttpServletRequest servletRequest) {
        Enumeration parameterNames = servletRequest.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>();
        while (parameterNames.hasMoreElements()) {
            String param = (String)parameterNames.nextElement();
            String value = servletRequest.getParameter(param);
            params.put(param, value);
        }
        return params;
    }
}

