/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.saml.bridge;

import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.module.ServerAuthModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.metadata.AuthzService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.impl.AuthzServiceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlServerAuthModule
implements ServerAuthModule {
    private static final Logger LOG = LoggerFactory.getLogger(SamlServerAuthModule.class);
    private static final Class<?>[] SUPPORTED_MESSAGE_TYPES = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private CallbackHandler callbackHandler;
    private String idpUrl;
    private SAMLPeerEntityContext entityContext;

    public Class[] getSupportedMessageTypes() {
        return SUPPORTED_MESSAGE_TYPES;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler callbackHandler, Map properties) throws AuthException {
        this.callbackHandler = callbackHandler;
        this.idpUrl = (String)properties.get("saml.idp.url");
        try {
            InitializationService.initialize();
        }
        catch (InitializationException e) {
            throw new AuthException(e.getMessage());
        }
        AuthzService authzService = new AuthzServiceBuilder().buildObject();
        authzService.setResponseLocation(this.idpUrl);
        authzService.setLocation(this.idpUrl);
        SAMLEndpointContext endpointContext = new SAMLEndpointContext();
        endpointContext.setEndpoint((Endpoint)authzService);
        this.entityContext = new SAMLPeerEntityContext();
        this.entityContext.addSubcontext((BaseContext)endpointContext);
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject subject) throws AuthException {
        return AuthStatus.SEND_SUCCESS;
    }

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            return AuthStatus.SUCCESS;
        }
        LOG.debug("request {}", (Object)request.getRequestURL());
        try {
            UserInfo userInfo = this.checkSamlRespone(request);
            if (userInfo != null) {
                return this.applyUserInfo(clientSubject, userInfo);
            }
            this.redirectSamlRequest(request, response);
        }
        catch (Exception e) {
            LOG.error("ups", (Throwable)e);
            throw new AuthException(e.getMessage());
        }
        return AuthStatus.FAILURE;
    }

    private void redirectSamlRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String consumerServiceURL = request.getRequestURL().toString();
        if (request.getQueryString() != null) {
            consumerServiceURL = String.format("%s?%s", consumerServiceURL, request.getQueryString());
        }
        AuthnRequest authnRequest = new AuthnRequestBuilder().buildObject();
        authnRequest.setAssertionConsumerServiceURL(consumerServiceURL);
        authnRequest.setDestination(this.idpUrl);
        authnRequest.setForceAuthn(Boolean.valueOf(false));
        authnRequest.setID(UUID.randomUUID().toString());
        authnRequest.setIsPassive(Boolean.valueOf(false));
        authnRequest.setIssueInstant(DateTime.now());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        NameIDPolicy nameIDPolicy = new NameIDPolicyBuilder().buildObject();
        nameIDPolicy.setAllowCreate(Boolean.valueOf(true));
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        authnRequest.setNameIDPolicy(nameIDPolicy);
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(consumerServiceURL);
        authnRequest.setIssuer(issuer);
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)authnRequest);
        messageContext.addSubcontext((BaseContext)this.entityContext);
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setMessageContext(messageContext);
        encoder.setHttpServletResponse(response);
        encoder.initialize();
        encoder.encode();
    }

    private UserInfo checkSamlRespone(HttpServletRequest request) throws Exception {
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse == null) {
            return null;
        }
        HTTPPostDecoder decoder = new HTTPPostDecoder();
        decoder.setHttpServletRequest(request);
        decoder.initialize();
        decoder.decode();
        Response response = (Response)decoder.getMessageContext().getMessage();
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("oauth");
        String name = null;
        for (Assertion assertion : response.getAssertions()) {
            if (assertion.getSubject() != null) {
                name = assertion.getSubject().getNameID().getValue();
            }
            for (AttributeStatement statement : assertion.getAttributeStatements()) {
                for (Attribute attribute : statement.getAttributes()) {
                    if (!"Role".equals(attribute.getName())) continue;
                    for (XMLObject xmlObject : attribute.getAttributeValues()) {
                        if (!(xmlObject instanceof XSString)) continue;
                        XSString xsString = (XSString)xmlObject;
                        groups.add(xsString.getValue());
                    }
                }
            }
        }
        UserInfo userInfo = new UserInfo(new com.nimbusds.oauth2.sdk.id.Subject(name));
        userInfo.setName(name);
        userInfo.setClaim("groups", groups);
        request.setAttribute("userInfo", (Object)userInfo);
        return userInfo;
    }

    private AuthStatus applyUserInfo(Subject clientSubject, UserInfo userInfo) throws AuthException {
        try {
            String name = userInfo.getName();
            List groups = (List)userInfo.getClaim("groups");
            this.callbackHandler.handle(new Callback[]{new CallerPrincipalCallback(clientSubject, name), new GroupPrincipalCallback(clientSubject, groups.toArray(new String[groups.size()]))});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
        return AuthStatus.SUCCESS;
    }
}

