/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.saml.bridge;

import de.adorsys.oauth.saml.bridge.SamlServerContext;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;

public class SamlServerAuthConfig
implements ServerAuthConfig {
    private final CallbackHandler callbackHandler;
    private final String appContext;
    private final Map<String, String> properties;
    private final String layer;

    public SamlServerAuthConfig(String layer, String appContext, CallbackHandler callbackHandler, Map<String, String> properties) {
        this.layer = layer;
        this.appContext = appContext;
        this.callbackHandler = callbackHandler;
        this.properties = properties;
    }

    public ServerAuthContext getAuthContext(String layer, Subject serviceSubject, Map properties) throws AuthException {
        return new SamlServerContext(layer, serviceSubject, this.callbackHandler, this.properties);
    }

    public String getAppContext() {
        return this.appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return this.appContext;
    }

    public String getMessageLayer() {
        return this.layer;
    }

    public boolean isProtected() {
        return false;
    }

    public void refresh() {
    }
}

