/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.saml.bridge;

import de.adorsys.oauth.saml.bridge.SamlAuthConfigProvider;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class JaspicStartupListener
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(JaspicStartupListener.class);
    private SamlAuthConfigProvider configProvider;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        String contextPath = servletContextEvent.getServletContext().getContextPath();
        LOG.info("initialize for {}", (Object)contextPath);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!entry.getKey().toString().startsWith("saml.")) continue;
            properties.put((String)entry.getKey(), (String)entry.getValue());
        }
        ServletContext servletContext = servletContextEvent.getServletContext();
        Enumeration paramEnum = servletContext.getInitParameterNames();
        while (paramEnum.hasMoreElements()) {
            String key = (String)paramEnum.nextElement();
            if (!key.startsWith("saml.")) continue;
            properties.put(key, servletContext.getInitParameter(key));
        }
        this.configProvider = new SamlAuthConfigProvider(properties, AuthConfigFactory.getFactory(), contextPath);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.configProvider != null) {
            AuthConfigFactory.getFactory().removeRegistration(this.configProvider.getRegistrationId());
        }
    }
}

