/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import de.adorsys.oauth.authdispatcher.FixedServletUtils;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceOwnerPasswordCredentialFlowValve
extends ValveBase {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceOwnerPasswordCredentialFlowValve.class);
    private String clientSecurityDomain;

    public void invoke(Request request, Response response) throws IOException, ServletException {
        TokenRequest tokenRequest = this.resolveTokenRequest(request);
        if (tokenRequest == null) {
            this.getNext().invoke(request, response);
            return;
        }
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (authorizationGrant.getType() != GrantType.PASSWORD) {
            this.getNext().invoke(request, response);
            return;
        }
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authorizationGrant;
        String userName = grant.getUsername();
        String password = grant.getPassword().getValue();
        LOG.debug("ResourceOwnerPasswordCredentialFlow - login {} {}", (Object)userName, (Object)password.replaceAll(".", "x"));
        Principal principal = this.getContainer().getRealm().authenticate(userName, password);
        request.setUserPrincipal(principal);
        if (principal == null) {
            ServletUtils.applyHTTPResponse((HTTPResponse)new TokenErrorResponse(OAuth2Error.ACCESS_DENIED).toHTTPResponse(), (HttpServletResponse)response);
        } else {
            this.getNext().invoke(request, response);
        }
    }

    private TokenRequest resolveTokenRequest(Request httpRequest) {
        try {
            return TokenRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest((HttpServletRequest)httpRequest));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

