/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.loginmodule;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPAuthenticationLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPAuthenticationLoginModule.class);
    private static final CloseableHttpClient HTTP_CLIENT;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, Object> sharedState;
    private URI restEndpoint;
    private ArrayList<Principal> preparedPrincipals;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        String restEndpointString = (String)options.get("restEndpoint");
        if (restEndpointString == null) {
            throw new IllegalStateException("Missing required option restEndpoint");
        }
        try {
            this.restEndpoint = new URI(restEndpointString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Missing required option restEndpoint has no url format", e);
        }
    }

    @Override
    public boolean login() throws LoginException {
        NameCallback nameCallback = new NameCallback("name");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            this.callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception x) {
            throw new LoginException(x.getMessage());
        }
        String username = nameCallback.getName();
        char[] passwordChars = passwordCallback.getPassword();
        String password = passwordChars == null ? null : new String(passwordChars);
        LOG.info("login {}", (Object)username);
        try {
            return this.authenticate(username, password);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    private boolean authenticate(String username, String password) throws LoginException {
        HttpHost targetHost = new HttpHost(this.restEndpoint.getHost(), this.restEndpoint.getPort(), this.restEndpoint.getScheme());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme(Consts.UTF_8);
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        HttpGet httpGet = new HttpGet(this.restEndpoint);
        CloseableHttpResponse userInfoResponse = null;
        try {
            userInfoResponse = HTTP_CLIENT.execute((HttpUriRequest)httpGet, (HttpContext)context);
            if (userInfoResponse.getStatusLine().getStatusCode() != 200) {
                LOG.error("Authentication failed for user {}, restEndpoint {} HTTP Status {}", new Object[]{username, this.restEndpoint.toASCIIString(), userInfoResponse.getStatusLine()});
                throw new LoginException("Authentication failed for user " + username + ", restEndpoint " + this.restEndpoint.toASCIIString() + " HTTP Status " + userInfoResponse.getStatusLine());
            }
            String userInfoJson = this.readUserInfo(userInfoResponse);
            JSONObject userInfo = new JSONObject(userInfoJson);
            String principalId = userInfo.getString("principal");
            if (principalId == null) {
                LOG.error("could not read  field 'principal' for user {}. Response: {}", (Object)username, (Object)userInfoJson);
                throw new LoginException("could not read  field 'principal' for user " + username + ". Response: " + userInfoJson);
            }
            JSONArray roles = userInfo.getJSONArray("roles");
            this.populateSubject(principalId, (Iterable<Object>)roles);
            this.sharedState.put("javax.security.auth.login.name", principalId);
            this.sharedState.put("javax.security.auth.login.password", password);
        }
        catch (IOException e) {
            throw new IllegalStateException("problem on http backend authentication", e);
        }
        finally {
            if (userInfoResponse != null) {
                try {
                    userInfoResponse.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private SimplePrincipal populateSubject(String principalId, Iterable<Object> roles) {
        this.preparedPrincipals = new ArrayList();
        SimplePrincipal principal = new SimplePrincipal(principalId);
        this.preparedPrincipals.add((Principal)principal);
        SimpleGroup callerGroup = new SimpleGroup("CallerPrincipal");
        this.preparedPrincipals.add((Principal)callerGroup);
        callerGroup.addMember((Principal)principal);
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        this.preparedPrincipals.add((Principal)rolesGroup);
        if (roles != null) {
            for (Object object : roles) {
                if (!(object instanceof String)) continue;
                rolesGroup.addMember((Principal)new SimplePrincipal((String)object));
            }
        }
        return principal;
    }

    private String readUserInfo(CloseableHttpResponse userInfoResponse) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        userInfoResponse.getEntity().writeTo((OutputStream)baos);
        String content = new String(baos.toByteArray(), "UTF-8");
        LOG.debug("read userinfo {}", (Object)content);
        return content;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.preparedPrincipals != null) {
            this.subject.getPrincipals().addAll(this.preparedPrincipals);
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.logout();
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject = null;
        this.preparedPrincipals = null;
        return true;
    }

    static {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        HTTP_CLIENT = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
    }
}

