/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.loginmodule;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.jacc.PolicyContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingLoginModule
implements LoginModule {
    private static final Logger log = LoggerFactory.getLogger(DelegatingLoginModule.class);
    private static final String CLIENT_ID_LIST = "de.adorsys.oauth.loginmodule.clientid.list";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String clientIdList;
    private LoginContext loginContext;
    private boolean loginSucceded = false;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.clientIdList = (String)options.get(CLIENT_ID_LIST);
        if (StringUtils.isEmpty((CharSequence)this.clientIdList)) {
            log.error("No client_ids for delegation configured");
            throw new IllegalStateException("No client_ids for delegation configured");
        }
    }

    @Override
    public boolean login() throws LoginException {
        ClientID clientID = this.resolveClientID();
        this.verifyClientID(clientID);
        this.loginContext = new LoginContext(clientID.getValue(), this.subject, this.callbackHandler);
        this.loginContext.login();
        this.loginSucceded = true;
        return true;
    }

    private ClientID resolveClientID() throws LoginException {
        try {
            AuthorizationRequest authorizationRequest = (AuthorizationRequest)PolicyContext.getContext((String)AuthorizationRequest.class.getName());
            return authorizationRequest.getClientID();
        }
        catch (Exception e) {
            log.trace("Exception parsing auth request", (Throwable)e);
            try {
                TokenRequest tokenRequest = (TokenRequest)PolicyContext.getContext((String)TokenRequest.class.getName());
                if (tokenRequest.getClientID() == null && tokenRequest.getClientAuthentication() != null) {
                    return tokenRequest.getClientAuthentication().getClientID();
                }
                return tokenRequest.getClientID();
            }
            catch (Exception exception) {
                throw new LoginException("ClientID extraction failed");
            }
        }
    }

    private void verifyClientID(ClientID clientID) throws LoginException {
        if (clientID == null || StringUtils.isEmpty((CharSequence)clientID.toString())) {
            log.warn("Received call with invalid client_id: " + clientID);
            throw new LoginException("Invalid client_id");
        }
        String[] clientIDs = this.clientIdList.split(",");
        if (!Arrays.asList(clientIDs).contains(clientID.getValue())) {
            log.warn("Received call with unkown client_id: " + clientID);
            throw new LoginException("Unkown client_id");
        }
    }

    @Override
    public boolean commit() throws LoginException {
        return this.loginSucceded;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.loginContext != null) {
            this.loginContext.logout();
            return true;
        }
        return false;
    }
}

