/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.authdispatcher.matcher;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import de.adorsys.oauth.authdispatcher.matcher.BaseAuthenticatorMatcher;
import de.adorsys.oauth.server.ResourceOwnerPasswordCredentialFlowValve;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.valves.ValveBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceOwnerPasswordCredentialsFlowMatcher
extends BaseAuthenticatorMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceOwnerPasswordCredentialsFlowMatcher.class);

    public ResourceOwnerPasswordCredentialsFlowMatcher() {
        this.valve = new ResourceOwnerPasswordCredentialFlowValve();
    }

    @Override
    public ValveBase match(HttpServletRequest request, AuthorizationRequest authorizationRequest) {
        TokenRequest tokenRequest = null;
        try {
            tokenRequest = (TokenRequest)PolicyContext.getContext((String)TokenRequest.class.getName());
        }
        catch (PolicyContextException e) {
            LOG.error("policy context exception", (Throwable)e);
        }
        if (tokenRequest == null) {
            return null;
        }
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (authorizationGrant.getType() == GrantType.PASSWORD) {
            return this.valve;
        }
        return null;
    }
}

