/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.authdispatcher;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class FixedServletUtils {
    private static String reconstructRequestURLString(HttpServletRequest request) {
        String path;
        StringBuilder sb = new StringBuilder("http");
        if (request.isSecure()) {
            sb.append('s');
        }
        sb.append("://");
        String localAddress = request.getLocalAddr();
        if (localAddress.contains(".")) {
            sb.append(localAddress);
        } else if (localAddress.contains(":")) {
            sb.append('[');
            sb.append(localAddress);
            sb.append(']');
        }
        if (!request.isSecure() && request.getLocalPort() != 80) {
            sb.append(':');
            sb.append(request.getLocalPort());
        }
        if (request.isSecure() && request.getLocalPort() != 443) {
            sb.append(':');
            sb.append(request.getLocalPort());
        }
        if ((path = request.getRequestURI()) != null) {
            sb.append(path);
        }
        return sb.toString();
    }

    public static HTTPRequest createHTTPRequest(HttpServletRequest sr) throws IOException {
        return FixedServletUtils.createHTTPRequest(sr, -1L);
    }

    public static HTTPRequest createHTTPRequest(HttpServletRequest sr, long maxEntityLength) throws IOException {
        URL url;
        HTTPRequest.Method method = HTTPRequest.Method.valueOf((String)sr.getMethod().toUpperCase());
        String urlString = FixedServletUtils.reconstructRequestURLString(sr);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid request URL: " + e.getMessage() + ": " + urlString, e);
        }
        HTTPRequest request = new HTTPRequest(method, url);
        try {
            request.setContentType(sr.getContentType());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid Content-Type header value: " + e.getMessage(), e);
        }
        Enumeration headerNames = sr.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            request.setHeader(headerName, sr.getHeader(headerName));
        }
        if (method.equals((Object)HTTPRequest.Method.GET) || method.equals((Object)HTTPRequest.Method.DELETE)) {
            request.setQuery(sr.getQueryString());
        } else if (method.equals((Object)HTTPRequest.Method.POST) || method.equals((Object)HTTPRequest.Method.PUT)) {
            if (maxEntityLength > 0L && (long)sr.getContentLength() > maxEntityLength) {
                throw new IOException("Request entity body is too large, limit is " + maxEntityLength + " chars");
            }
            Map parameterMap = sr.getParameterMap();
            StringBuilder builder = new StringBuilder();
            if (!parameterMap.isEmpty()) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String[] value = (String[])entry.getValue();
                    if (value.length <= 0 || value[0] == null) continue;
                    String encoded = URLEncoder.encode(value[0], "UTF-8");
                    builder = builder.append(key).append('=').append(encoded).append('&');
                }
                String queryString = StringUtils.substringBeforeLast((String)builder.toString(), (String)"&");
                request.setQuery(queryString);
            } else {
                int readChars;
                StringBuilder body = new StringBuilder(256);
                BufferedReader reader = sr.getReader();
                char[] cbuf = new char[256];
                while ((readChars = reader.read(cbuf)) != -1) {
                    body.append(cbuf, 0, readChars);
                    if (maxEntityLength <= 0L || (long)body.length() <= maxEntityLength) continue;
                    throw new IOException("Request entity body is too large, limit is " + maxEntityLength + " chars");
                }
                reader.close();
                request.setQuery(body.toString());
            }
        }
        return request;
    }
}

