/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.loginmodule;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClientIdLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthClientIdLoginModule.class);
    private boolean success;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
    }

    @Override
    public boolean login() throws LoginException {
        this.validateRequest();
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    private boolean validateRequest() throws LoginException {
        HttpServletRequest request = this.fromPolicyContext(HttpServletRequest.class);
        if (request != null && request.getUserPrincipal() != null) {
            return false;
        }
        AuthorizationRequest authorizationRequest = this.fromPolicyContext(AuthorizationRequest.class);
        if (authorizationRequest == null) {
            return false;
        }
        ClientID clientID = authorizationRequest.getClientID();
        String redirectionURIs = System.getProperty("oauth.clients." + clientID + ".redirectionURIs");
        if (redirectionURIs == null) {
            LOG.warn("Unknow OAUTH ClientID {} requested a token. Please define system property 'oauth.clients.{}.redirectionURIs'.", (Object)clientID, (Object)clientID);
            throw new LoginException("Unknow OAUTH ClientID {} requested a token. Please define system property 'oauth.clients.{}.redirectionURIs'.");
        }
        String redirectUri = authorizationRequest.getRedirectionURI().toString();
        for (String allowedUri : Arrays.asList(redirectionURIs.split(","))) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)redirectUri, (CharSequence)allowedUri)) continue;
            return true;
        }
        LOG.warn("OAUTH ClientID {} requested a token but the redirect urls does not match. Actual redirectionurl {} is not defined in {}.", new Object[]{clientID, authorizationRequest.getRedirectionURI(), redirectionURIs});
        throw new LoginException("OAUTH ClientID {} requested a token but the redirect urls does not match. Actual redirectionurl {} is not defined in {}.");
    }

    private <T> T fromPolicyContext(Class<T> type) {
        try {
            return (T)PolicyContext.getContext((String)type.getName());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

