/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.authdispatcher.matcher;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessFormAuthenticator
extends AuthenticatorBase {
    private static final String ORIGIN_PARAM = "origin";
    private static final Logger LOG = LoggerFactory.getLogger(StatelessFormAuthenticator.class);
    public static final String FORM_ACTION = "/j_security_check";
    public static final String FORM_PASSWORD = "j_password";
    public static final String FORM_USERNAME = "j_username";
    public static final String EXCEPTION_ATTR = "javax.servlet.error.exception";
    protected String characterEncoding = null;

    protected boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            return true;
        }
        if ("GET".equals(request.getMethod())) {
            this.showLoginPage(request, response, config);
        }
        if ("POST".equals(request.getMethod())) {
            if (this.characterEncoding != null) {
                request.setCharacterEncoding(this.characterEncoding);
            }
            String username = request.getParameter(FORM_USERNAME);
            String password = request.getParameter(FORM_PASSWORD);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authenticating username '" + username + "'");
            }
            if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                this.register(request, response, principal, "FORM", username, password);
                return true;
            }
            this.showErrorPage(request, response, config);
        }
        return false;
    }

    private void showLoginPage(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        RequestDispatcher dispatcher = this.context.getServletContext().getRequestDispatcher(config.getLoginPage());
        try {
            dispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (Exception e) {
            LOG.warn("formAuthenticator.forwardLoginFail", (Throwable)e);
            request.setAttribute(EXCEPTION_ATTR, (Object)e);
            response.sendError(500, "formAuthenticator.forwardErrorFail");
        }
    }

    private void showErrorPage(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        RequestDispatcher dispatcher = this.context.getServletContext().getRequestDispatcher(config.getErrorPage());
        try {
            dispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (Exception e) {
            LOG.warn("formAuthenticator.forwardLoginFail", (Throwable)e);
            request.setAttribute(EXCEPTION_ATTR, (Object)e);
            response.sendError(500, "formAuthenticator.redirectLoginPage");
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }
}

