/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.authdispatcher.matcher;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import de.adorsys.oauth.authdispatcher.matcher.BaseAuthenticatorMatcher;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang3.StringUtils;

public class RememberMeAuthMatcher
extends BaseAuthenticatorMatcher {
    public RememberMeAuthMatcher() {
        this.valve = new AuthenticatorBase(){

            protected boolean authenticate(Request request, HttpServletResponse response, LoginConfig lc) throws IOException {
                Principal principal = this.context.getRealm().authenticate("guest", "test");
                if (principal != null) {
                    this.register(request, response, principal, "FORM", "guest", "test");
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public ValveBase match(HttpServletRequest request, AuthorizationRequest authorizationRequest) {
        if (!"/auth".equals(request.getPathInfo()) || authorizationRequest == null || authorizationRequest.getClientID() == null) {
            return null;
        }
        if (!this.shouldRememberMe(request)) {
            return null;
        }
        Cookie cookieToken = this.getCookieToken(authorizationRequest.getClientID().getValue(), request);
        return cookieToken != null ? this.valve : null;
    }

    private Cookie getCookieToken(String clientId, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals("REMEMBER_" + clientId) || !StringUtils.isNotEmpty((CharSequence)cookie.getValue())) continue;
            return cookie;
        }
        return null;
    }

    private boolean shouldRememberMe(HttpServletRequest request) {
        return !"false".equals(request.getParameter("rememberme"));
    }
}

