/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import de.adorsys.oauth.authdispatcher.FixedServletUtils;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceOwnerPasswordCredentialFlowValve
extends ValveBase {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceOwnerPasswordCredentialFlowValve.class);
    private String clientSecurityDomain;

    public void invoke(Request request, Response response) throws IOException, ServletException {
        TokenRequest tokenRequest = this.resolveTokenRequest(request);
        if (tokenRequest == null) {
            this.getNext().invoke(request, response);
            return;
        }
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (authorizationGrant.getType() != GrantType.PASSWORD) {
            this.getNext().invoke(request, response);
            return;
        }
        if (!this.verifyClientCredentials(request)) {
            response.setStatus(403);
            response.getWriter().write("client authentification failed");
            response.finishResponse();
            return;
        }
        ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authorizationGrant;
        String userName = grant.getUsername();
        String password = grant.getPassword().getValue();
        LOG.debug("ResourceOwnerPasswordCredentialFlow - login {} {}", (Object)userName, (Object)password.replaceAll(".", "x"));
        Principal principal = this.getContainer().getRealm().authenticate(userName, password);
        request.setUserPrincipal(principal);
        this.getNext().invoke(request, response);
    }

    private boolean verifyClientCredentials(Request httpRequest) {
        String[] stringArray;
        if (this.clientSecurityDomain == null) {
            return true;
        }
        String authValue = httpRequest.getHeader("Authorization");
        if (authValue == null || !authValue.startsWith("Basic ")) {
            return false;
        }
        String encodedValue = authValue.substring(6);
        String decodedValue = new String(Base64.decodeBase64((String)encodedValue));
        if (decodedValue.contains(":")) {
            stringArray = decodedValue.split(":");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = decodedValue;
            stringArray = stringArray2;
            stringArray2[1] = "";
        }
        final String[] namePassword = stringArray;
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(namePassword[0]);
                        continue;
                    }
                    if (!(callback instanceof PasswordCallback)) continue;
                    ((PasswordCallback)callback).setPassword(namePassword[1].toCharArray());
                }
            }
        };
        Subject subject = new Subject();
        try {
            LoginContext loginContext = new LoginContext(this.clientSecurityDomain, subject, callbackHandler);
            loginContext.login();
            loginContext.logout();
        }
        catch (LoginException e) {
            LOG.error("call securitydomain " + callbackHandler, (Throwable)e);
            return false;
        }
        return true;
    }

    private TokenRequest resolveTokenRequest(Request httpRequest) {
        try {
            return TokenRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest((HttpServletRequest)httpRequest));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setClientSecurityDomain(String clientSecurityDomain) {
        this.clientSecurityDomain = clientSecurityDomain;
    }
}

