/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.loginmodule;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.LdapUsersLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapPwCheckLoginModule
extends LdapUsersLoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(LdapPwCheckLoginModule.class);
    private static final String DEFAULT_ROLE = "defaultRole";
    private transient SimpleGroup userRoles = new SimpleGroup("Roles");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(new String[]{DEFAULT_ROLE});
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        if (!super.login()) {
            return false;
        }
        String password = (String)this.sharedState.get("javax.security.auth.login.password");
        if (this.validatePassword(password, null)) {
            this.defaultRole();
            return true;
        }
        LOG.error("LDAP error {}", this.getValidateError());
        throw new LoginException(this.getValidateError().getMessage());
    }

    private void defaultRole() {
        String defaultRole = (String)this.options.get(DEFAULT_ROLE);
        try {
            if (defaultRole == null || defaultRole.equals("")) {
                return;
            }
            Principal p = super.createIdentity(defaultRole);
            PicketBoxLogger.LOGGER.traceAssignUserToRole(defaultRole);
            this.userRoles.addMember(p);
        }
        catch (Exception e) {
            PicketBoxLogger.LOGGER.debugFailureToCreatePrincipal(defaultRole, (Throwable)e);
        }
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[]{this.userRoles};
    }
}

