/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.loginmodule;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import org.jboss.as.security.RealmUsersRolesLoginModule;

public class ClientSecretRealmUserLoginModule
extends RealmUsersRolesLoginModule {
    private Map sharedState;
    private boolean abort = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.sharedState = sharedState;
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean login() throws LoginException {
        boolean returnValue = super.login();
        try {
            TokenRequest tokenRequest = (TokenRequest)PolicyContext.getContext((String)TokenRequest.class.getName());
            AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
            if (authorizationGrant.getType() == GrantType.PASSWORD) {
                ResourceOwnerPasswordCredentialsGrant grant = (ResourceOwnerPasswordCredentialsGrant)authorizationGrant;
                this.sharedState.put("javax.security.auth.login.name", grant.getUsername());
                this.sharedState.put("javax.security.auth.login.password", grant.getPassword().getValue());
                this.abort = true;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }

    public boolean commit() throws LoginException {
        if (this.abort) {
            super.abort();
            return false;
        }
        return super.commit();
    }

    public boolean abort() throws LoginException {
        return super.abort();
    }

    public boolean logout() throws LoginException {
        return super.logout();
    }
}

