/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.authdispatcher.matcher;

import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import de.adorsys.oauth.authdispatcher.FixedServletUtils;
import de.adorsys.oauth.authdispatcher.matcher.BaseAuthenticatorMatcher;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthAuthenticatorMatcher
extends BaseAuthenticatorMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthAuthenticatorMatcher.class);

    public BasicAuthAuthenticatorMatcher() {
        try {
            this.valve = (ValveBase)BasicAuthAuthenticatorMatcher.class.getClassLoader().loadClass("org.apache.catalina.authenticator.BasicAuthenticator").newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ValveBase match(HttpServletRequest request, AuthorizationRequest authorizationRequest) {
        if (BasicAuthAuthenticatorMatcher.isBasicAuthentication(request)) {
            return this.valve;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"POST", (CharSequence)request.getMethod())) {
            return null;
        }
        try {
            TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)FixedServletUtils.createHTTPRequest(request));
            if (tokenRequest.getAuthorizationGrant().getType() == GrantType.PASSWORD) {
                return this.valve;
            }
        }
        catch (Exception e) {
            LOG.warn("Can not load authenticator", (Throwable)e);
        }
        return null;
    }

    private static boolean isBasicAuthentication(HttpServletRequest httpServletRequest) {
        for (String name : Collections.list(httpServletRequest.getHeaderNames())) {
            if (!"authorization".equalsIgnoreCase(name)) continue;
            return httpServletRequest.getHeader(name).substring(0, 5).equalsIgnoreCase("Basic");
        }
        return false;
    }
}

